/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.cache;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.cache.PerspectiveCacheArtifact;
import com.ibm.ba.glass.cache.PerspectiveFilter;
import com.ibm.ba.glass.exception.JSONFormatException;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.loader.PerspectiveLoader;
import com.ibm.ba.glass.model.PerspectiveProcessor;
import com.ibm.ba.glass.resource.Perspective;
import com.ibm.ba.glass.resource.ResourceFile;
import com.ibm.ba.glass.utils.JsonObjectUtils;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.ArrayList;
import java.util.Set;
import javax.inject.Inject;

public abstract class BasePerspectivesCache {
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_EXTENSION = "extension";
    private static final String PROPERTY_DEFINITION = "definition";
    private static final String[] excludedPerspectiveIds = new String[]{"common"};
    @Inject
    private PerspectiveProcessor perspectiveProcessor;
    @Inject
    @Managed
    private PerspectiveLoader perspectiveLoader;

    public void initPerspectivesCache() throws JSONFormatException {
        this.emptyCache();
        ArrayList<Perspective> perspectives = this.perspectiveLoader.getEmbeddedPerspectivesList();
        for (Perspective perspective : perspectives) {
            String perspectiveName = perspective.getPerspectiveName();
            JsonObject perspectiveSpec = JsonObjectUtils.convertToJsonObject(perspective.getPerspectiveSpec());
            this.addPerspectiveToCache(perspectiveName, perspectiveSpec);
        }
    }

    public boolean getLensable(JsonObject spec) {
        boolean lensable = true;
        if (spec.containsKey((Object)"lensable")) {
            lensable = spec.getBoolean("lensable");
        }
        return lensable;
    }

    public void cacheExtensionPerspectives(JsonObject jsonSpec, ResourceFile specResource) {
        JsonArray extensions = jsonSpec.getArray("extensions");
        for (int i = 0; i < extensions.size(); ++i) {
            JsonObject extension = (JsonObject)extensions.get(i);
            String perspectiveID = extension.getString("perspective");
            if (this.isPerspectiveIDExcluded(perspectiveID) || this.containsPerspectiveID(perspectiveID, specResource)) continue;
            this.addNewPerspectiveExtensionToCache(jsonSpec, extension, specResource);
        }
    }

    public boolean isPerspectiveIDExcluded(String perspectiveID) {
        boolean isExcluded = false;
        for (String id : excludedPerspectiveIds) {
            if (!id.equals(perspectiveID)) continue;
            isExcluded = true;
        }
        return isExcluded;
    }

    public boolean containsPerspectiveID(String perspectiveID, ResourceFile specResource) {
        return this.getCacheKeySet().contains(perspectiveID);
    }

    public void addDefaultPerspectiveValues(JsonObject perspectiveJson, PerspectiveCacheArtifact artifact, PerspectiveFilter filter) {
        perspectiveJson.put(PROPERTY_NAME, (Object)artifact.getPerspectiveId());
        if (artifact.isExtension()) {
            perspectiveJson.put(PROPERTY_EXTENSION, (Object)artifact.getExtensionId());
        }
        if (filter.containsField(PROPERTY_DEFINITION)) {
            JsonObject rawDefinition = this.getRawDefinition(artifact);
            perspectiveJson.put(PROPERTY_DEFINITION, (Object)filter.apply(rawDefinition));
        }
    }

    public JsonObject getRawDefinition(PerspectiveCacheArtifact artifact) {
        return artifact.getDefinition();
    }

    public JsonObject generateRawDefinition(String perspectiveId) throws ResourceNotFoundException {
        return this.perspectiveProcessor.generateRawDefinition(perspectiveId);
    }

    public JsonArray getPerspectives() {
        return this.getPerspectives(new PerspectiveFilter());
    }

    public abstract JsonArray getPerspectives(PerspectiveFilter var1);

    public abstract void addPerspectiveToCache(String var1, JsonObject var2);

    public abstract void addNewPerspectiveExtensionToCache(JsonObject var1, JsonObject var2, ResourceFile var3);

    public abstract Set<String> getCacheKeySet();

    public abstract PerspectiveCacheArtifact getPerspectiveCacheArtifact(String var1);

    public abstract void emptyCache();

    public abstract void injectPerspectiveDefinitions() throws ResourceNotFoundException;
}

