/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.cache;

import com.ibm.ba.glass.annotations.Cache;
import com.ibm.ba.glass.cache.BasePerspectivesCache;
import com.ibm.ba.glass.cache.PerspectiveCacheArtifact;
import com.ibm.ba.glass.cache.PerspectiveFilter;
import com.ibm.ba.glass.cache.PerspectivesCache;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.resource.ResourceFile;
import com.ibm.ba.glass.utils.ExtensionArtifactCache;
import com.ibm.ba.glass.utils.ExtensionArtifactCacheGImpl;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.io.Serializable;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.lang.SerializationUtils;

@ApplicationScoped
@Cache(value="Glass")
public class GlassPerspectivesCache
extends BasePerspectivesCache
implements PerspectivesCache {
    private static final ExtensionArtifactCache<String, PerspectiveCacheArtifact> cache = new ExtensionArtifactCacheGImpl<String, PerspectiveCacheArtifact>();

    @Override
    public void addPerspectiveToCache(String perspectiveId, JsonObject jsonSpec) {
        PerspectiveCacheArtifact artifact = new PerspectiveCacheArtifact(perspectiveId, this.getLensable(jsonSpec));
        cache.put(perspectiveId, artifact);
    }

    @Override
    public void addNewPerspectiveExtensionToCache(JsonObject jsonSpec, JsonObject extension, ResourceFile specResource) {
        String extensionId = jsonSpec.getString("name");
        String schemaVersion = jsonSpec.getString("schemaVersion");
        String type = extension.getString("type");
        String perspectiveId = extension.getString("perspective");
        PerspectiveCacheArtifact artifact = new PerspectiveCacheArtifact(perspectiveId, this.getLensable(extension), extensionId, type, schemaVersion);
        cache.put(perspectiveId, artifact);
    }

    @Override
    public PerspectiveCacheArtifact getPerspectiveCacheArtifact(String perspectiveId) {
        return cache.get(perspectiveId);
    }

    @Override
    public JsonArray getPerspectives(PerspectiveFilter filter) {
        JsonArray json = new JsonArray();
        for (String perspectiveId : cache.getkeySet()) {
            PerspectiveCacheArtifact artifactCopy = (PerspectiveCacheArtifact)SerializationUtils.clone((Serializable)cache.get(perspectiveId));
            if (!filter.apply(artifactCopy)) continue;
            JsonObject perspectiveJson = new JsonObject();
            this.addDefaultPerspectiveValues(perspectiveJson, artifactCopy, filter);
            json.add((Object)perspectiveJson);
        }
        return json;
    }

    @Override
    public void injectPerspectiveDefinitions() throws ResourceNotFoundException {
        for (String perspectiveId : this.getCacheKeySet()) {
            PerspectiveCacheArtifact artifact = this.getPerspectiveCacheArtifact(perspectiveId);
            JsonObject definition = this.generateRawDefinition(artifact.getPerspectiveId());
            artifact.setDefinition(definition);
        }
    }

    @Override
    public Set<String> getCacheKeySet() {
        return cache.getkeySet();
    }

    @Override
    public void emptyCache() {
        cache.emptyCache();
    }

    protected ExtensionArtifactCache<String, PerspectiveCacheArtifact> getPerspectivesCache() {
        return cache;
    }
}

