/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.cache;

import com.ibm.ba.glass.cache.PerspectiveCacheArtifact;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerspectiveFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerspectiveFilter.class);
    private String type;
    private Boolean isExtension;
    private Boolean isLensable;
    private Set<String> fields;

    public void setType(String value) {
        this.type = value;
    }

    public String getType() {
        return this.type;
    }

    public void setIsExtension(Boolean value) {
        this.isExtension = value;
    }

    public void setIsLensable(Boolean value) {
        this.isLensable = value;
    }

    public Boolean getIsExtension() {
        return this.isExtension;
    }

    public Boolean getIsLensable() {
        return this.isLensable;
    }

    public void setFields(Set<String> value) {
        this.fields = value;
    }

    public boolean containsField(String field) {
        return this.fields != null && this.fields.contains(field);
    }

    public boolean apply(PerspectiveCacheArtifact artifact) {
        return this.applyType(artifact) && this.applyIsExtension(artifact) && this.applyIsLensable(artifact);
    }

    public JsonObject apply(JsonObject definition) {
        JsonObject filteredDefinition = (JsonObject)definition.clone();
        this.lensePerspectiveDefinition(filteredDefinition);
        return filteredDefinition;
    }

    private boolean applyType(PerspectiveCacheArtifact artifact) {
        return this.type == null || artifact.isType(this.type);
    }

    private boolean applyIsExtension(PerspectiveCacheArtifact artifact) {
        return this.isExtension == null || this.isExtension.equals(artifact.isExtension());
    }

    private boolean applyIsLensable(PerspectiveCacheArtifact artifact) {
        return this.isLensable == null || this.isLensable.equals(artifact.isLensable());
    }

    private void lensePerspectiveDefinition(JsonObject definition) {
        if (Boolean.TRUE.equals(this.isLensable)) {
            this.filterElementsOnObject(definition, true);
        }
    }

    private void filterElementsOnObject(JsonObject json, boolean isLensable) {
        Set entrySet = json.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object value = entry.getValue();
            if (value instanceof JsonObject) {
                boolean isObjLensable;
                JsonObject obj = (JsonObject)value;
                Boolean lensable = this.getBoolean(obj, "lensable");
                boolean bl = isObjLensable = lensable == null ? true : lensable;
                if (isObjLensable == isLensable) {
                    this.filterElementsOnObject(obj, isLensable);
                    continue;
                }
                iterator.remove();
                continue;
            }
            if (!(value instanceof JsonArray)) continue;
            this.filterElementsOnArray((JsonArray)value, isLensable);
        }
    }

    private void filterElementsOnArray(JsonArray json, boolean isLensable) {
        for (int i = json.size() - 1; i >= 0; --i) {
            Object value = json.get(i);
            if (value instanceof JsonObject) {
                boolean isObjLensable;
                JsonObject obj = (JsonObject)value;
                Boolean lensable = this.getBoolean(obj, "lensable");
                boolean bl = isObjLensable = lensable == null ? true : lensable;
                if (isObjLensable == isLensable) {
                    this.filterElementsOnObject(obj, isLensable);
                    continue;
                }
                json.remove(i);
                continue;
            }
            if (!(value instanceof JsonArray)) continue;
            this.filterElementsOnArray((JsonArray)value, isLensable);
        }
    }

    private Boolean getBoolean(JsonObject json, String propertyName) {
        Boolean value = null;
        try {
            value = json.getBoolean(propertyName);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing boolean", (Throwable)e);
        }
        return value;
    }
}

