/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.cache;

import com.ibm.ba.glass.utils.ExtensionArtifactCache;
import com.ibm.ba.glass.utils.ExtensionArtifactCacheGImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WhiteListCache {
    private static final ExtensionArtifactCache<String, Set<String>> cache = new ExtensionArtifactCacheGImpl<String, Set<String>>();
    private static final Map<String, Set<String>> transientWhiteLists = new HashMap<String, Set<String>>();
    private static WhiteListCache instance;

    public static WhiteListCache getInstance() {
        if (instance == null) {
            instance = new WhiteListCache();
        }
        return instance;
    }

    public void addWhiteListItem(String key, String value) {
        Set<String> whiteList = transientWhiteLists.get(key);
        if (whiteList == null) {
            whiteList = new HashSet<String>();
            transientWhiteLists.put(key, whiteList);
        }
        whiteList.add(value);
    }

    public boolean checkWhiteList(String key, String value) {
        Set<String> validList = cache.get(key);
        if (validList != null) {
            return validList.contains(value);
        }
        throw new IllegalArgumentException("Unknown whitelist key: " + key);
    }

    public void clearCache() {
        cache.emptyCache();
    }

    public void cacheTransientWhiteLists() {
        for (Map.Entry<String, Set<String>> transientWhiteListEntrySet : transientWhiteLists.entrySet()) {
            Set<String> transientWhiteList = transientWhiteListEntrySet.getValue();
            HashSet<String> whiteList = new HashSet<String>(transientWhiteList);
            cache.put(transientWhiteListEntrySet.getKey(), whiteList);
            transientWhiteList.clear();
        }
    }
}

