/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.endpoints;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.api.ThemeContext;
import com.ibm.ba.glass.builtin.BuiltInThemes;
import com.ibm.ba.glass.cache.CacheKeyGenerator;
import com.ibm.ba.glass.endpoints.BaseConsumptionResource;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.loader.CurrentThemeLoader;
import com.ibm.ba.glass.utils.CacheArtifact;
import com.ibm.ba.glass.utils.ESException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/themes/current")
public class CurrentThemeResource
extends BaseConsumptionResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentThemeResource.class);
    @Inject
    @Managed
    ThemeContext themeContext;
    @Inject
    @Managed
    private CacheKeyGenerator cacheKeyGenerator;
    @Inject
    @Managed
    public CurrentThemeLoader curThemeLoader;
    @Inject
    private BuiltInThemes builtInThemes;

    @PostConstruct
    public void initCurrentThemeLoader() {
        this.curThemeLoader.setHttpServletRequest(this.httpServletRequest);
    }

    @GET
    @Path(value="{path:.*\\.json}")
    @Produces(value={"application/json"})
    public Response getThemeSpec() throws ResourceNotFoundException, ESException {
        return this.buildResponse(this.curThemeLoader.getThemeSpecResource(this.getCurrentTheme()), this.getCurrentTheme(), "application/json");
    }

    @GET
    @Path(value="{path:.*\\.jpg}")
    @Produces(value={"image/jpg"})
    public Response getJpgImage(@PathParam(value="path") List<PathSegment> pathSegmentList) throws ResourceNotFoundException, ESException {
        return this.getImage(pathSegmentList, "image/jpg");
    }

    @GET
    @Path(value="{path:.*\\.jpeg}")
    @Produces(value={"image/jpeg"})
    public Response getJpegImage(@PathParam(value="path") List<PathSegment> pathSegmentList) throws ResourceNotFoundException, ESException {
        return this.getImage(pathSegmentList, "image/jpeg");
    }

    @GET
    @Path(value="{path:.*\\.png}")
    @Produces(value={"image/png"})
    public Response getPngImage(@PathParam(value="path") List<PathSegment> pathSegmentList) throws ResourceNotFoundException, ESException {
        return this.getImage(pathSegmentList, "image/png");
    }

    @GET
    @Path(value="{path:.*\\.gif}")
    @Produces(value={"image/gif"})
    public Response getGifImage(@PathParam(value="path") List<PathSegment> pathSegmentList) throws ResourceNotFoundException, ESException {
        return this.getImage(pathSegmentList, "image/gif");
    }

    @GET
    @Path(value="{path:.*\\.svg}")
    @Produces(value={"image/svg+xml"})
    public Response getSvgImage(@PathParam(value="path") List<PathSegment> pathSegmentList) throws ResourceNotFoundException, ESException {
        return this.getImage(pathSegmentList, "image/svg+xml");
    }

    @GET
    @Path(value="{path:.*\\.css}")
    @Produces(value={"text/css"})
    public Response getThemeCSS() throws ResourceNotFoundException, ESException {
        return this.buildResponse(this.curThemeLoader.getThemeCssResource(this.getCurrentTheme()), this.getCurrentTheme(), "text/css");
    }

    @GET
    @Path(value="favicon")
    public Response getFavicon() throws ResourceNotFoundException, ESException {
        return this.buildResponse(this.curThemeLoader.getThemeFavIconResource(this.getCurrentTheme()), this.getCurrentTheme(), null);
    }

    private String getCurrentTheme() {
        return this.themeContext.getThemeName();
    }

    protected Response getImage(List<PathSegment> pathSegmentList, String imageType) throws ResourceNotFoundException, ESException {
        if (this.builtInThemes.isBuiltIn(this.getCurrentTheme())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.buildResponse(this.curThemeLoader.getJaxrsFile(this.getCurrentTheme(), pathSegmentList), this.getCurrentTheme(), imageType);
    }

    @Override
    protected CacheArtifact getCacheArtifact(String customizationName) {
        try {
            String cacheKey = this.builtInThemes.isBuiltIn(customizationName) ? customizationName : this.cacheKeyGenerator.getCacheKey(customizationName, this.httpServletRequest);
            return this.getExtensionUtils().getThemeCache().get(cacheKey);
        }
        catch (ESException error) {
            LOGGER.debug("Unable to get cache key.");
            return null;
        }
    }
}

