/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.endpoints;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.endpoints.BaseConsumptionResource;
import com.ibm.ba.glass.exception.InvalidInputException;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.loader.ExtensionLoader;
import com.ibm.ba.glass.resource.BaseJaxrsFileResource;
import com.ibm.ba.glass.utils.CacheArtifact;
import com.ibm.ba.glass.utils.ESException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.commons.json.JSONObject;

@Path(value="/extensions")
public class ExtensionResource
extends BaseConsumptionResource {
    protected static final String EXTENSIONS = "extensions";
    protected static final String MASTER_EXTENSION = "masterExtension";
    @Inject
    @Managed
    public ExtensionLoader extLoader;

    @PostConstruct
    public void initExtensionLoader() {
        this.extLoader.setHttpServletRequest(this.httpServletRequest);
    }

    @GET
    @Path(value="{extensionName}/zip")
    @Produces(value={"application/octet-stream"})
    public Response getExtensionData(@PathParam(value="extensionName") String extensionName) throws ESException {
        byte[] themeZipData = this.extLoader.getExtensionZip(extensionName);
        if (themeZipData == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)themeZipData).header("Content-Disposition", (Object)this.getAttachmentHeaderField(extensionName)).build();
    }

    @GET
    @Path(value="{extensionName: (?!current)[^/]+}/{path:.*\\.png}")
    @Produces(value={"image/png"})
    public Response getPngImage(@PathParam(value="extensionName") String name, @PathParam(value="path") List<PathSegment> pathSegmentList) throws ESException {
        return this.buildResourceResponse(pathSegmentList, name, "image/png");
    }

    @GET
    @Path(value="{extensionName: (?!current)[^/]+}/{path:.*\\.jpg}")
    @Produces(value={"image/jpg"})
    public Response getJpgImage(@PathParam(value="extensionName") String name, @PathParam(value="path") List<PathSegment> pathSegmentList) throws ESException {
        return this.buildResourceResponse(pathSegmentList, name, "image/jpg");
    }

    @GET
    @Path(value="{extensionName: (?!current)[^/]+}/{path:.*\\.jpeg}")
    @Produces(value={"image/jpeg"})
    public Response getJpegImage(@PathParam(value="extensionName") String name, @PathParam(value="path") List<PathSegment> pathSegmentList) throws ESException {
        return this.buildResourceResponse(pathSegmentList, name, "image/jpeg");
    }

    @GET
    @Path(value="{extensionName: (?!current)[^/]+}/{path:.*\\.svg}")
    @Produces(value={"image/svg+xml"})
    public Response getSvgImage(@PathParam(value="extensionName") String name, @PathParam(value="path") List<PathSegment> pathSegmentList) throws ESException {
        return this.buildResourceResponse(pathSegmentList, name, "image/svg+xml");
    }

    @GET
    @Path(value="{extensionName: (?!current)[^/]+}/{path:.*\\.js}")
    @Produces(value={"application/javascript"})
    public Response getJavascript(@PathParam(value="extensionName") String name, @PathParam(value="path") List<PathSegment> pathSegmentList) throws ESException {
        return this.buildResourceResponse(pathSegmentList, name, "application/javascript");
    }

    @GET
    @Path(value="{extensionName: (?!current)[^/]+}/{path:.*\\.json}")
    @Produces(value={"application/json"})
    public Response getJson(@PathParam(value="extensionName") String name, @PathParam(value="path") List<PathSegment> pathSegmentList) throws ESException {
        return this.buildResourceResponse(pathSegmentList, name, "application/json");
    }

    @GET
    @Path(value="{extensionName: (?!current)[^/]+}/{path:.*\\.html}")
    @Produces(value={"text/html"})
    public Response getHtml(@PathParam(value="extensionName") String name, @PathParam(value="path") List<PathSegment> pathSegmentList) throws ESException {
        return this.buildResourceResponse(pathSegmentList, name, "text/html");
    }

    @GET
    @Path(value="{extensionName: (?!current)[^/]+}/{path:.*\\.css}")
    @Produces(value={"text/css"})
    public Response getCss(@PathParam(value="extensionName") String name, @PathParam(value="path") List<PathSegment> pathSegmentList) throws ESException {
        return this.buildResourceResponse(pathSegmentList, name, "text/css");
    }

    protected Response buildResourceResponse(List<PathSegment> pathSegmentList, String name, String imageType) throws ESException {
        BaseJaxrsFileResource resource = this.extLoader.getJaxrsFile(name, pathSegmentList);
        return this.buildResponse(resource, name, imageType);
    }

    @Override
    protected CacheArtifact getCacheArtifact(String customizationName) {
        return this.getExtensionUtils().getExtensionCache().get(EXTENSIONS);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getExtensions() throws ESException {
        JSONObject response = this.extLoader.getExtensions();
        return Response.ok((Object)response, (String)"application/json").build();
    }

    @DELETE
    @Path(value="{extensionName: (?!current)[^/]+}")
    public Response deleteExtension(@PathParam(value="extensionName") String extName) throws ESException, InvalidInputException, ResourceNotFoundException {
        this.extLoader.deleteExtension(extName);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"application/json"})
    public Response addExtension(InputStream zipStream) throws InvalidInputException, ESException {
        return this.handleExtension(null, zipStream);
    }

    @PUT
    @Path(value="{extensionName: (?!current)[^/]+}")
    @Consumes(value={"application/zip"})
    @Produces(value={"application/json"})
    public Response updateExtension(InputStream zipStream, @PathParam(value="extensionName") String extensionName) throws InvalidInputException, ESException {
        return this.handleExtension(extensionName, zipStream);
    }

    private Response handleExtension(String extName, InputStream zipStream) throws InvalidInputException, ESException {
        this.extLoader.initialize(zipStream);
        JSONObject response = this.extLoader.uploadExtension(extName, zipStream);
        if (response == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.status((Response.Status)this.getStatus(extName)).entity((Object)response).type("application/json").build();
    }

    @GET
    @Path(value="/current")
    @Produces(value={"application/json"})
    public Response getMasterExtension() throws ESException {
        JSONObject masterExtension = this.extLoader.getMasterExtension();
        if (masterExtension == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        EntityTag et = new EntityTag(MASTER_EXTENSION);
        Response result = this.checkPreconditions(et);
        if (result != null) {
            return result;
        }
        return Response.ok((Object)masterExtension).tag(new EntityTag(MASTER_EXTENSION)).lastModified(this.extLoader.getMasterExtensionLastModified()).cacheControl(this.createCacheControl()).build();
    }

    private Response checkPreconditions(EntityTag et) {
        Response.ResponseBuilder builder = this.rsRequest.evaluatePreconditions(et);
        if (builder != null) {
            builder = Response.notModified();
            return builder.build();
        }
        return null;
    }
}

