/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.endpoints;

import com.google.common.collect.Sets;
import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.api.PerspectiveContext;
import com.ibm.ba.glass.api.PerspectiveFilterManager;
import com.ibm.ba.glass.builtin.BuiltInThemes;
import com.ibm.ba.glass.cache.CacheKeyGenerator;
import com.ibm.ba.glass.cache.PerspectiveFilter;
import com.ibm.ba.glass.cache.PerspectiveFilterFactory;
import com.ibm.ba.glass.cache.PerspectivesCache;
import com.ibm.ba.glass.cache.WhiteListCache;
import com.ibm.ba.glass.defaults.DefaultTheme;
import com.ibm.ba.glass.endpoints.BaseResource;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.loader.CurrentThemeLoader;
import com.ibm.ba.glass.loader.PerspectiveLoader;
import com.ibm.ba.glass.model.GFModel;
import com.ibm.ba.glass.model.GFModelConfig;
import com.ibm.ba.glass.resource.BaseJaxrsFileResource;
import com.ibm.ba.glass.resource.Theme;
import com.ibm.ba.glass.spi.PerspectiveListFilter;
import com.ibm.ba.glass.utils.CacheArtifact;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.ba.glass.utils.JsonObjectUtils;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/perspectives")
public class PerspectivesResource
extends BaseResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerspectivesResource.class);
    private static final String CAPABILITIES = "capabilities";
    private static final String CLIENT_CONTEXT_NAME = "context";
    private static final String PROPERTY_DEFINITION = "definition";
    private static final String FILTERS = "filters";
    private List<PerspectiveListFilter> perspectiveListFilters = new ArrayList<PerspectiveListFilter>();
    @Context
    protected UriInfo uriInfo;
    @Context
    private HttpServletRequest httpServletRequest;
    @Inject
    @Managed
    PerspectiveContext perspectiveContext;
    @Inject
    PerspectiveFilterManager perspectiveFilterManager;
    @Inject
    @Managed
    private PerspectiveLoader perspectiveLoader;
    @Inject
    @Managed
    private PerspectivesCache perspectivesCache;
    @Inject
    @Managed
    private CacheKeyGenerator cacheKeyGenerator;
    @Inject
    private DefaultTheme defaultTheme;
    @Inject
    @Managed
    private CurrentThemeLoader curThemeLoader;
    @Inject
    protected BuiltInThemes builtInThemes;

    @Inject
    public void injectPerspectiveListFilters(@Any Instance<PerspectiveListFilter> filters) {
        if (!filters.isUnsatisfied()) {
            for (PerspectiveListFilter filter : filters) {
                this.perspectiveListFilters.add(filter);
            }
        }
        this.perspectiveListFilters.sort((filterOne, filterTwo) -> {
            if (filterOne.getOrder() == filterTwo.getOrder()) {
                return 0;
            }
            if (filterOne.getOrder() > filterTwo.getOrder()) {
                return 1;
            }
            return -1;
        });
    }

    @PostConstruct
    public void initCurrentThemeLoader() {
        this.curThemeLoader.setHttpServletRequest(this.httpServletRequest);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getPerspectivesList() throws ESException {
        Date lastModified = null;
        EntityTag etag = null;
        Response result = null;
        if (!this.isCacheDisabled()) {
            lastModified = this.getExtensionModificationTime();
            etag = this.buildEtag(lastModified);
            result = this.checkPreconditions(etag);
        }
        if (result == null) {
            PerspectiveFilter filter = this.getFilterInstance();
            JsonArray perspectives = this.perspectivesCache.getPerspectives(filter);
            this.applyPerspectiveListFilters(perspectives);
            this.applySPIFilters(perspectives);
            Response.ResponseBuilder builder = Response.ok((Object)perspectives);
            builder = this.isCacheDisabled() ? builder : builder.tag(etag).lastModified(lastModified).cacheControl(this.createCacheControl());
            return builder.build();
        }
        return result;
    }

    @GET
    @Path(value="{perspectiveId}")
    @Produces(value={"application/json"})
    public Response getPerspectiveDefinition(@PathParam(value="perspectiveId") String perspectiveId) throws ResourceNotFoundException {
        String pid = this.resolvePerspectiveId(perspectiveId, this.perspectiveContext);
        EntityTag etag = null;
        Response result = null;
        if (!this.isCacheDisabled()) {
            etag = this.buildEtag(pid, this.perspectiveContext);
            result = this.checkPreconditions(etag);
        }
        if (result != null) {
            return result;
        }
        GFModelConfig modelConfig = this.getModelConfig(pid, this.perspectiveContext);
        this.perspectiveLoader.load(modelConfig);
        GFModel model = this.createModel();
        JSONObject perspectiveSpecJSONObject = model.getCombinedJSON(modelConfig, this.perspectiveLoader);
        JsonObject perspectiveSpec = JsonObjectUtils.convertToJsonObject(perspectiveSpecJSONObject);
        if (this.userHasPerspectiveCapabilities((JsonArray)perspectiveSpec.get(CAPABILITIES)).booleanValue()) {
            this.perspectiveFilterManager.doFilter(perspectiveSpec, this.perspectiveContext);
            perspectiveSpec.set(CLIENT_CONTEXT_NAME, (Object)this.perspectiveContext.getClientContext());
            Response.ResponseBuilder builder = Response.ok((Object)perspectiveSpec);
            builder = this.isCacheDisabled() ? builder : builder.tag(etag).cacheControl(this.createCacheControl());
            return builder.build();
        }
        Response.ResponseBuilder builder = Response.status((int)403);
        return builder.build();
    }

    @GET
    @Path(value="{perspectiveId}/urls/{base64Url}")
    @Produces(value={"application/json"})
    public Response getUrl(@PathParam(value="perspectiveId") String perspectiveId, @PathParam(value="base64Url") String base64Url) throws ResourceNotFoundException {
        Date lastModified = null;
        EntityTag etag = null;
        Response result = null;
        if (!this.isCacheDisabled()) {
            lastModified = this.getExtensionModificationTime();
            etag = this.buildEtag(lastModified);
            result = this.checkPreconditions(etag);
        }
        if (result != null) {
            return result;
        }
        String url = new String(Base64.decodeBase64((String)base64Url));
        Response.ResponseBuilder builder = WhiteListCache.getInstance().checkWhiteList("url", url) ? Response.noContent() : Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)url);
        builder = this.isCacheDisabled() ? builder : builder.tag(etag).lastModified(lastModified).cacheControl(this.createCacheControl());
        return builder.build();
    }

    protected GFModelConfig getModelConfig(String perspectiveId, PerspectiveContext perspectiveContext) {
        return new GFModelConfig(perspectiveId, perspectiveContext.getLocale(), this.getCurrentThemeSpec(perspectiveContext), JsonObjectUtils.convertToJSONObject(perspectiveContext.getExtensions()));
    }

    private Theme getCurrentThemeSpec(PerspectiveContext perspectiveContext) {
        try {
            BaseJaxrsFileResource themeSpec = this.curThemeLoader.getThemeSpecResource(perspectiveContext.getThemeName());
            JsonObject themeSpecJson = themeSpec.getResourceAsJson();
            if (themeSpecJson != null) {
                return new Theme(themeSpecJson);
            }
        }
        catch (ResourceNotFoundException | ESException error) {
            LOGGER.error("Request for current theme spec returned invalid JSON.", (Throwable)error);
        }
        return new Theme(this.defaultTheme.getSpec());
    }

    protected boolean isCacheDisabled() {
        return Boolean.getBoolean("glass.disable.cache");
    }

    protected Response checkPreconditions(EntityTag etag) {
        Response.ResponseBuilder builder = this.getRESTRequest().evaluatePreconditions(etag);
        return builder != null ? builder.build() : null;
    }

    protected EntityTag buildEtag(Date lastModified) {
        String lastModifiedString = lastModified != null ? lastModified.toString() : "";
        String etag = this.getNumberOfExtensions() + lastModifiedString;
        return new EntityTag(etag);
    }

    protected EntityTag buildEtag(String perspectiveId, PerspectiveContext perspectiveContext) {
        String currentTheme = perspectiveContext.getThemeName();
        String themeComponent = currentTheme + this.getThemeModificationTime(currentTheme);
        Date extensionModificationTime = this.getExtensionModificationTime();
        String extensionModificationString = extensionModificationTime != null ? extensionModificationTime.toString() : "";
        String extensionComponent = this.getNumberOfExtensions() + extensionModificationString;
        String contextHash = perspectiveContext.getEtagHash();
        return new EntityTag(themeComponent + extensionComponent + perspectiveId + contextHash);
    }

    protected String getThemeModificationTime(String themeName) {
        CacheArtifact currentThemeArtifact;
        try {
            String cacheKey = this.builtInThemes.isBuiltIn(themeName) ? themeName : this.cacheKeyGenerator.getCacheKey(themeName, this.httpServletRequest);
            currentThemeArtifact = this.getExtensionUtils().getThemeCache().get(cacheKey);
        }
        catch (ESException error) {
            LOGGER.debug("Unable to get cache key.");
            currentThemeArtifact = null;
        }
        if (currentThemeArtifact != null) {
            return currentThemeArtifact.getModificationTime().toString();
        }
        return "";
    }

    protected Date getExtensionModificationTime() {
        CacheArtifact artifact = this.getExtensionUtils().getExtensionCache().get("extensions");
        return artifact != null ? artifact.getModificationTime() : null;
    }

    protected long getNumberOfExtensions() {
        return this.getExtensionUtils().getExtensionCache().size();
    }

    protected PerspectiveFilter getFilterInstance() {
        return PerspectiveFilterFactory.create((MultivaluedMap<String, String>)this.uriInfo.getQueryParameters());
    }

    protected String resolvePerspectiveId(String perspectiveId, PerspectiveContext perspectiveContext) {
        if ("login".equals(perspectiveId)) {
            return perspectiveContext.getLoginPerspective();
        }
        if ("IBMlogin".equals(perspectiveId)) {
            return "login";
        }
        return perspectiveId;
    }

    protected GFModel createModel() {
        return new GFModel();
    }

    protected void applySPIFilters(JsonArray perspectives) {
        HashSet filters;
        String filtersParam = (String)this.uriInfo.getQueryParameters().getFirst((Object)FILTERS);
        HashSet hashSet = filters = filtersParam != null ? Sets.newHashSet((Object[])filtersParam.split(",")) : null;
        if (filters != null) {
            for (Object perspective : perspectives) {
                if (!(perspective instanceof JsonObject)) continue;
                JsonObject definition = ((JsonObject)perspective).getObject(PROPERTY_DEFINITION);
                this.perspectiveFilterManager.doFilter(definition, this.perspectiveContext, filters);
            }
        }
    }

    private void applyPerspectiveListFilters(JsonArray perspectives) {
        for (PerspectiveListFilter filter : this.perspectiveListFilters) {
            filter.doFilter(perspectives);
        }
    }

    private Boolean userHasPerspectiveCapabilities(JsonArray perspectiveCapabilities) {
        if (perspectiveCapabilities == null || perspectiveCapabilities.size() == 0) {
            return true;
        }
        JsonArray userCapabilities = (JsonArray)this.perspectiveContext.getAdditionalContext(CAPABILITIES).get("context_part_jsonarray_values");
        if (userCapabilities == null || userCapabilities.size() == 0) {
            return true;
        }
        Boolean userHasCapabilities = true;
        for (int i = 0; i < perspectiveCapabilities.size(); ++i) {
            if (userCapabilities.contains(perspectiveCapabilities.get(i))) continue;
            userHasCapabilities = false;
        }
        return userHasCapabilities;
    }
}

