/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.endpoints;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.api.PermissionManager;
import com.ibm.ba.glass.builtin.BuiltInThemeCache;
import com.ibm.ba.glass.builtin.BuiltInThemes;
import com.ibm.ba.glass.builtin.ThemeModel;
import com.ibm.ba.glass.endpoints.BaseResource;
import com.ibm.ba.glass.exception.InvalidInputException;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.loader.ThemeLoader;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.bi.json.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/themes")
public class ThemeResource
extends BaseResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeResource.class);
    public PermissionManager permissionManager = null;
    @Inject
    @Managed
    public ThemeLoader themeLoader;
    @Inject
    protected BuiltInThemeCache builtInThemeCache;
    @Inject
    protected BuiltInThemes builtInThemes;

    @PostConstruct
    public void initThemeLoader() {
        this.themeLoader.setHttpServletRequest(this.httpServletRequest);
    }

    @Inject
    public void initPermissionManager(Instance<PermissionManager> permissionManagers) {
        block0: {
            PermissionManager pm;
            Iterator iterator;
            if (permissionManagers.isUnsatisfied() || !(iterator = permissionManagers.iterator()).hasNext()) break block0;
            this.permissionManager = pm = (PermissionManager)iterator.next();
        }
    }

    @GET
    @Path(value="{themeName}/zip")
    @Produces(value={"application/octet-stream"})
    public Response getThemeData(@PathParam(value="themeName") String themeName) throws ESException {
        if (this.permissionManager != null && !this.permissionManager.canDownloadTheme(this.httpServletRequest)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.builtInThemes.isBuiltIn(themeName)) {
            return this.generateBuiltInThemeData(themeName);
        }
        byte[] themeZipData = this.themeLoader.getThemeZip(themeName);
        if (themeZipData == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)themeZipData).header("Content-Disposition", (Object)this.getAttachmentHeaderField(themeName)).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getThemes() throws ESException {
        JSONObject response = this.themeLoader.getThemes();
        ThemeModel[] builtInThemes = this.builtInThemeCache.getBuiltInThemes();
        this.addBuiltInThemesToResponse(response, builtInThemes);
        return Response.ok((Object)response, (String)"application/json").build();
    }

    private void addBuiltInThemesToResponse(JSONObject response, ThemeModel[] builtInThemes) throws ESException {
        Object[] formattedBuiltInThemes;
        for (Object formattedTheme : formattedBuiltInThemes = this.formatBuiltInThemesForResponse(builtInThemes)) {
            try {
                response.append("objects", formattedTheme);
            }
            catch (JSONException je) {
                String msg = "Error adding built-in themes to response";
                LOGGER.error(msg, (Throwable)je);
                throw new ESException(msg);
            }
        }
    }

    private Object[] formatBuiltInThemesForResponse(ThemeModel[] themes) {
        JSONArray formattedThemes = new JSONArray();
        for (ThemeModel themeModel : themes) {
            try {
                JSONObject builtInThemeJson = this.buildBuiltInThemeJson(themeModel);
                formattedThemes.add((Object)builtInThemeJson);
            }
            catch (JSONException je) {
                LOGGER.error("Failed to build built-in theme, ID: " + themeModel.getID(), (Throwable)je);
            }
        }
        return formattedThemes.toArray();
    }

    public JSONObject buildBuiltInThemeJson(ThemeModel themeModel) throws JSONException {
        JSONObject builtInThemeJson = new JSONObject();
        builtInThemeJson.put("builtInTheme", true);
        builtInThemeJson.put("id", (Object)themeModel.getID());
        builtInThemeJson.put("label", (Object)themeModel.getLabel());
        return builtInThemeJson;
    }

    @DELETE
    @Path(value="{themeName}")
    public Response deleteTheme(@PathParam(value="themeName") String themeName) throws ESException, ResourceNotFoundException {
        if (this.permissionManager != null && !this.permissionManager.canDeleteTheme(this.httpServletRequest)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.themeLoader.deleteTheme(themeName);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"application/json"})
    public Response addTheme(InputStream zipStream) throws InvalidInputException, ESException {
        return this.handleTheme(zipStream, null);
    }

    @PUT
    @Path(value="{themeName}")
    @Consumes(value={"application/zip"})
    @Produces(value={"application/json"})
    public Response updateTheme(InputStream zipStream, @PathParam(value="themeName") String themeName) throws InvalidInputException, ESException {
        return this.handleTheme(zipStream, themeName);
    }

    private Response handleTheme(InputStream zipStream, String themeName) throws InvalidInputException, ESException {
        if (this.permissionManager != null && !this.permissionManager.canUploadTheme(this.httpServletRequest)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.themeLoader.initialize(zipStream);
        JSONObject response = this.themeLoader.uploadTheme(themeName, zipStream);
        if (response == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.status((Response.Status)this.getStatus(themeName)).entity((Object)response).type("application/json").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response generateBuiltInThemeData(String themeName) {
        JsonObject themeSpec = this.builtInThemes.getSpec(themeName);
        String themeJsonStr = themeSpec.toString();
        ZipOutputStream zos = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            zos = new ZipOutputStream(os);
            ZipEntry entry = new ZipEntry("spec.json");
            zos.putNextEntry(entry);
            zos.write(themeJsonStr.getBytes());
            zos.closeEntry();
            zos.finish();
            zos.close();
            Response response = Response.ok((Object)os.toByteArray()).header("Content-Disposition", (Object)this.getAttachmentHeaderField(themeName)).build();
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Error creating theme zip file: " + themeName, (Throwable)e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close output stream.", (Throwable)e);
                }
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

