/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.exception;

import com.ibm.ba.glass.exception.InvalidInputException;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class GlassExceptionMapper
implements ExceptionMapper<Exception> {
    @Context
    protected HttpServletRequest request;
    private static final Logger LOGGER = LoggerFactory.getLogger(GlassExceptionMapper.class);

    public Response toResponse(Exception cause) {
        Response response;
        if (cause instanceof InvalidInputException) {
            Map<String, Object> propMap = ((InvalidInputException)((Object)cause)).toMap(this.request == null ? Locale.getDefault() : this.request.getLocale());
            response = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity(propMap).type("application/json").build();
        } else {
            response = cause instanceof ResourceNotFoundException ? Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).build() : Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).type("application/json").build();
        }
        LOGGER.error(cause.getMessage(), (Throwable)cause);
        return response;
    }
}

