/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.factory;

import com.ibm.ba.glass.annotations.CacheLiteral;
import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.cache.CacheKeyGenerator;
import com.ibm.ba.glass.cache.PerspectivesCache;
import com.ibm.ba.glass.utils.CustomPropertyUtils;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CacheFactory {
    public static final String PERSPECTIVES_CACHE = "com.ibm.ba.PerspectivesCache";
    public static final String CACHE_KEY_GENERATOR = "com.ibm.ba.CacheKeyGenerator";
    public static final String DEFAULT_CACHE = "Glass";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheFactory.class);
    @Inject
    @Any
    private Instance<PerspectivesCache> perspectivesCaches;
    @Inject
    @Any
    private Instance<CacheKeyGenerator> cacheKeyGenerators;

    @Produces
    @Managed
    public PerspectivesCache getPerspectivesCache() {
        CacheLiteral qualifier = new CacheLiteral(this.getCacheName(PERSPECTIVES_CACHE));
        try {
            return (PerspectivesCache)this.perspectivesCaches.select(new Annotation[]{qualifier}).get();
        }
        catch (UnsatisfiedResolutionException err) {
            LOGGER.error("Unable to get PerspectivesCache. Most likely caused by invalid cache set in system properties (the com.ibm.ba.PerspectivesCache value).");
            err.printStackTrace();
            return null;
        }
    }

    @Produces
    @Managed
    public CacheKeyGenerator getCacheKeyGenerator() {
        CacheLiteral qualifier = new CacheLiteral(this.getCacheName(CACHE_KEY_GENERATOR));
        try {
            return (CacheKeyGenerator)this.cacheKeyGenerators.select(new Annotation[]{qualifier}).get();
        }
        catch (UnsatisfiedResolutionException err) {
            LOGGER.error("Unable to get CacheKeyGenerator. Most likely caused by invalid cache set in system properties (the com.ibm.ba.CacheKeyGenerator value).");
            err.printStackTrace();
            return null;
        }
    }

    private String getCacheName(String lookupValue) {
        return CustomPropertyUtils.readCustomProperty(lookupValue, DEFAULT_CACHE);
    }
}

