/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.factory;

import com.ibm.ba.glass.annotations.DefaultThemeLiteral;
import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.defaults.DefaultThemeDefinition;
import com.ibm.ba.glass.factory.LoaderFactory;
import com.ibm.ba.glass.utils.CustomPropertyUtils;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultThemeFactory {
    public static final String DEFAULT_THEME = "com.ibm.ba.DefaultTheme";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoaderFactory.class);
    @Inject
    @Any
    private Instance<DefaultThemeDefinition> defaultThemes;

    @Produces
    @Managed
    public DefaultThemeDefinition getDefaultTheme() {
        DefaultThemeLiteral qualifier = new DefaultThemeLiteral(this.getDefaultThemeLoader(DEFAULT_THEME));
        try {
            return (DefaultThemeDefinition)this.defaultThemes.select(new Annotation[]{qualifier}).get();
        }
        catch (UnsatisfiedResolutionException err) {
            LOGGER.error("Unable to get DefaultTheme. Most likely caused by invalid loader set in system properties (the com.ibm.ba.DefaultTheme value).");
            err.printStackTrace();
            return null;
        }
    }

    private String getDefaultThemeLoader(String lookupValue) {
        return CustomPropertyUtils.readCustomProperty(lookupValue, "Glass");
    }
}

