/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.factory;

import com.ibm.ba.glass.annotations.LoaderLiteral;
import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.loader.CurrentThemeLoader;
import com.ibm.ba.glass.loader.ExtensionLoader;
import com.ibm.ba.glass.loader.PerspectiveLoader;
import com.ibm.ba.glass.loader.ThemeLoader;
import com.ibm.ba.glass.utils.CustomPropertyUtils;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LoaderFactory {
    public static final String CURRENT_THEME_LOADER = "com.ibm.ba.CurrentThemeLoader";
    public static final String THEME_LOADER = "com.ibm.ba.ThemeLoader";
    public static final String EXTENSION_LOADER = "com.ibm.ba.ExtensionLoader";
    public static final String PERSPECTIVE_LOADER = "com.ibm.ba.PerspectiveLoader";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoaderFactory.class);
    @Inject
    @Any
    private Instance<CurrentThemeLoader> currentThemeLoaders;
    @Inject
    @Any
    private Instance<ThemeLoader> themeLoaders;
    @Inject
    @Any
    private Instance<ExtensionLoader> extLoaders;
    @Inject
    @Any
    private Instance<PerspectiveLoader> perspectiveLoaders;

    @Produces
    @Managed
    public CurrentThemeLoader getCurrentThemeLoader() {
        LoaderLiteral qualifier = new LoaderLiteral(this.getLoaderName(CURRENT_THEME_LOADER));
        try {
            return (CurrentThemeLoader)this.currentThemeLoaders.select(new Annotation[]{qualifier}).get();
        }
        catch (UnsatisfiedResolutionException err) {
            LOGGER.error("Unable to get CurrentThemeLoader. Most likely caused by invalid loader set in system properties (the com.ibm.ba.CurrentThemeLoader value).");
            err.printStackTrace();
            return null;
        }
    }

    @Produces
    @Managed
    public ThemeLoader getThemeLoader() {
        LoaderLiteral qualifier = new LoaderLiteral(this.getLoaderName(THEME_LOADER));
        try {
            return (ThemeLoader)this.themeLoaders.select(new Annotation[]{qualifier}).get();
        }
        catch (UnsatisfiedResolutionException err) {
            LOGGER.error("Unable to get ThemeLoader. Most likely caused by invalid loader set in system properties (the com.ibm.ba.ThemeLoader value).");
            err.printStackTrace();
            return null;
        }
    }

    @Produces
    @Managed
    public ExtensionLoader getExtensionLoader() {
        LoaderLiteral qualifier = new LoaderLiteral(this.getLoaderName(EXTENSION_LOADER));
        try {
            return (ExtensionLoader)this.extLoaders.select(new Annotation[]{qualifier}).get();
        }
        catch (UnsatisfiedResolutionException err) {
            LOGGER.error("Unable to get ExtensionLoader. Most likely caused by invalid loader set in system properties (the com.ibm.ba.ExtensionLoader value).");
            err.printStackTrace();
            return null;
        }
    }

    @Produces
    @Managed
    public PerspectiveLoader getPerspectiveLoader() {
        LoaderLiteral qualifier = new LoaderLiteral(this.getLoaderName(PERSPECTIVE_LOADER));
        try {
            return (PerspectiveLoader)this.perspectiveLoaders.select(new Annotation[]{qualifier}).get();
        }
        catch (UnsatisfiedResolutionException err) {
            LOGGER.error("Unable to get PerspectiveLoader. Most likely caused by invalid loader set in system properties (the com.ibm.ba.PerspectiveLoader value).");
            err.printStackTrace();
            return null;
        }
    }

    private String getLoaderName(String lookupValue) {
        return CustomPropertyUtils.readCustomProperty(lookupValue, "FileSystem");
    }
}

