/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.factory;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.api.ContextPart;
import com.ibm.ba.glass.api.PerspectiveContext;
import com.ibm.ba.glass.api.PerspectiveContextImpl;
import com.ibm.ba.glass.api.RequestInfo;
import com.ibm.ba.glass.loader.ExtensionLoader;
import com.ibm.ba.glass.spi.PerspectiveContextPartProvider;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.ba.glass.utils.JsonObjectUtils;
import com.ibm.bi.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PerspectiveContextFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerspectiveContextFactory.class);
    private List<PerspectiveContextPartProvider> providersList = new ArrayList<PerspectiveContextPartProvider>();
    @Inject
    @Managed
    private ExtensionLoader extLoader;
    @Inject
    private Provider<PerspectiveContextImpl> contexts;

    @Inject
    void initProviders(Instance<PerspectiveContextPartProvider> providers) {
        if (!providers.isUnsatisfied()) {
            for (PerspectiveContextPartProvider provider : providers) {
                this.providersList.add(provider);
            }
        }
    }

    @Produces
    @Managed
    public PerspectiveContext createPerspectiveContext(RequestInfo requestInfo) {
        PerspectiveContextImpl ctx = (PerspectiveContextImpl)this.contexts.get();
        ctx.setExtensions(this.getCurrentExtensions());
        StringBuilder etagHashString = new StringBuilder();
        for (PerspectiveContextPartProvider provider : this.providersList) {
            JsonObject extensions;
            ContextPart part = provider.create(requestInfo);
            if (part == null) continue;
            ctx.addContextPart(part);
            if (part.getExcludedFeatures() != null) {
                ctx.setExcludedFeatures(part.getExcludedFeatures());
            }
            if (part.getLoginPerspective() != null) {
                ctx.setLoginPerspective(part.getLoginPerspective());
            }
            if (part.getThemeName() != null) {
                ctx.setThemeName(part.getThemeName());
            }
            if ((extensions = part.getExtensions()) != null) {
                ctx.setExtensions(extensions);
            }
            if (part.getLocale() != null) {
                ctx.setLocale(part.getLocale());
            }
            if (part.getEtagHash() == null) continue;
            etagHashString.append(part.getEtagHash());
        }
        ctx.setEtagHash(etagHashString.toString());
        return ctx;
    }

    private JsonObject getCurrentExtensions() {
        try {
            JSONObject json = this.extLoader.getMasterExtension();
            return JsonObjectUtils.convertToJsonObject(json);
        }
        catch (ESException ioe) {
            LOGGER.error("Unable to get current extension spec. Defaulting to factoryMode.");
            return new JsonObject();
        }
    }
}

