/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.factory;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.annotations.RootFolderLiteral;
import com.ibm.ba.glass.resource.RootFolder;
import com.ibm.ba.glass.utils.CustomPropertyUtils;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RootFolderFactory {
    public static final String ROOT_FOLDER = "com.ibm.ba.RootFolder";
    private static final Logger LOGGER = LoggerFactory.getLogger(RootFolderFactory.class);
    private Instance<RootFolder> rootFolders;

    @Inject
    public void setRootFolders(@Any Instance<RootFolder> rootFolders) {
        this.rootFolders = rootFolders;
    }

    @Produces
    @Managed
    public RootFolder getRootFolder() {
        String rootFolderName = this.getRootFolderName();
        RootFolderLiteral qualifier = new RootFolderLiteral(rootFolderName);
        try {
            return (RootFolder)this.rootFolders.select(new Annotation[]{qualifier}).get();
        }
        catch (UnsatisfiedResolutionException ex) {
            LOGGER.error("Unable to retrieve RootFolder");
            ex.printStackTrace();
            return null;
        }
    }

    private String getRootFolderName() {
        return CustomPropertyUtils.readCustomProperty(ROOT_FOLDER, "FSRootFolder");
    }
}

