/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.loader;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.cache.CacheKeyGenerator;
import com.ibm.ba.glass.exception.InvalidInputException;
import com.ibm.ba.glass.resource.Resource;
import com.ibm.ba.glass.resource.ResourceFile;
import com.ibm.ba.glass.resource.RootFolder;
import com.ibm.ba.glass.resource.Specification;
import com.ibm.ba.glass.resource.ZippedFile;
import com.ibm.ba.glass.utils.CacheArtifact;
import com.ibm.ba.glass.utils.DirectoryHandler;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.ba.glass.utils.ExtensionArtifactCache;
import com.ibm.ba.glass.utils.ExtensionUtils;
import com.ibm.ba.glass.utils.JsonObjectUtils;
import com.ibm.ba.glass.utils.SpecUtils;
import com.ibm.ba.glass.utils.ZipHandler;
import com.ibm.ba.glass.utils.ZippedSpecUtils;
import com.ibm.bi.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FSBaseLoader {
    protected static final String NAME = "name";
    public static final String OBJECT_TYPE = "customization";
    private static final Logger LOGGER = LoggerFactory.getLogger(FSBaseLoader.class);
    @Inject
    DirectoryHandler directoryHandler;
    @Inject
    ZipHandler zipHandler;
    @Inject
    @Managed
    RootFolder folder;
    @Inject
    @Managed
    protected CacheKeyGenerator cacheKeyGenerator;
    protected List<ZippedFile> files;
    private HashMap<String, Object> options = new HashMap();
    protected HttpServletRequest httpServletRequest;

    public void initialize(InputStream zipStream) throws ESException {
        this.files = this.zipHandler.getZippedFiles(zipStream);
    }

    public HashMap<String, Object> getOptions() {
        return this.options;
    }

    public void injectRootFolder(RootFolder folder) {
        this.folder = folder;
    }

    public void setHandlers(DirectoryHandler dirHandler, ZipHandler zipHandler) {
        this.directoryHandler = dirHandler;
        this.zipHandler = zipHandler;
    }

    protected JsonObject parseString(String string) throws InvalidInputException {
        return SpecUtils.parseSpecString(string);
    }

    public String getRootFolder() throws ESException {
        if (this.folder == null) {
            throw new ESException("RootFolder is not injected");
        }
        return this.folder.getRootFolderPath();
    }

    public String getExtensionsFolder() throws ESException {
        if (this.folder == null) {
            throw new ESException("RootFolder is not injected");
        }
        return this.folder.getExtensionsRelativePath();
    }

    public String getExtensionsRoot() throws ESException {
        if (this.folder == null) {
            throw new ESException("RootFolder is not injected");
        }
        return this.folder.getExtensionsRoot();
    }

    public List<ZippedFile> getFiles() {
        return this.files;
    }

    protected File createDirectory(boolean rewrite, String dirPath, String name) throws ESException {
        StringBuilder sb = new StringBuilder().append(dirPath).append(File.separator).append(name);
        return this.directoryHandler.createDirectory(sb.toString(), rewrite);
    }

    public void deleteDirectory(String name) throws ESException {
        try {
            this.directoryHandler.deleteDirectory(this.directoryHandler.getFile(this.getDirectoryPath(name)));
        }
        catch (ESException e) {
            String msg = "Failed to delete.";
            if (this.getContainerName() != null && name != null) {
                msg = "Failed to delete " + this.getContainerName() + " " + name;
            }
            LOGGER.error(msg, (Throwable)e);
            throw new ESException("Unable to delete customization.");
        }
    }

    protected List<ResourceFile> walkDirectory(String targetPath) throws ESException {
        return this.directoryHandler.walkDirectory(targetPath);
    }

    protected JsonObject getSpecFromZip() throws InvalidInputException, ESException {
        List<ZippedFile> zippedFiles = this.getFiles();
        String schema = this.getSchema();
        return ZippedSpecUtils.getSpecFromZip(zippedFiles, schema);
    }

    protected File extractToFileSystem(String plugin, String name) throws ESException {
        try {
            File pluginDir = this.createDirectory(false, this.getRootFolder(), plugin);
            File specDir = this.createDirectory(true, pluginDir.getAbsolutePath(), name);
            this.zipHandler.extractToFileSystem(this.files, specDir.getAbsolutePath());
            return specDir;
        }
        catch (ESException e) {
            throw new ESException("Failed to extract to file system.", e);
        }
    }

    public String getDirectoryPath(String name) throws ESException {
        StringBuilder sb = new StringBuilder().append(this.getRootFolder()).append(File.separator).append(this.getContainerName()).append(File.separator).append(name);
        return sb.toString();
    }

    public void deleteFromCache(String name) throws ESException {
        ExtensionArtifactCache<String, CacheArtifact> cache = this.getCache();
        String cacheKey = this.cacheKeyGenerator.getCacheKey(name, this.httpServletRequest);
        cache.remove(cacheKey);
    }

    protected String getSchema() {
        return null;
    }

    public void initCustomizationCache(ExtensionArtifactCache<String, CacheArtifact> cache) throws ESException {
        String customizationDir = this.getCustomizationDirPath();
        Path customizationPath = Paths.get(customizationDir, new String[0]);
        if (Files.exists(customizationPath, new LinkOption[0])) {
            this.cacheCustomizations(cache, customizationPath);
        }
    }

    private void cacheCustomizations(ExtensionArtifactCache<String, CacheArtifact> cache, Path customizationPath) throws ESException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(customizationPath);){
            for (Path dir : directoryStream) {
                if (this.isFileIgnored(dir.toFile())) continue;
                this.cacheCustomization(cache, dir.toFile());
            }
        }
        catch (IOException e) {
            LOGGER.error("Error retrieving themes or extensions from file system", (Throwable)e);
            throw new ESException(e);
        }
    }

    private boolean isFileIgnored(File file) {
        return file.getName().equals(".DS_Store") || file.getName().equals("master");
    }

    protected String getCustomizationDirPath() throws ESException {
        StringBuilder sb = new StringBuilder().append(this.getRootFolder()).append(File.separator).append(this.getContainerName());
        return sb.toString();
    }

    protected void cacheCustomization(ExtensionArtifactCache<String, CacheArtifact> cache, File file) throws ESException {
        JsonObject object = new JsonObject();
        object.put("defaultName", (Object)file.getName());
        object.put("modificationTime", (Object)new Date(file.lastModified()).toInstant().toString());
        object.put("version", (Object)0);
        CacheArtifact artifact = this.createCacheArtifact(object);
        String cacheKey = this.cacheKeyGenerator.getCacheKey(file.getName(), this.httpServletRequest);
        cache.put(cacheKey, artifact);
    }

    protected CacheArtifact createCacheArtifact(JsonObject objectInfo) {
        return new CacheArtifact(objectInfo);
    }

    protected JSONObject buildCustomizationContent() throws ESException {
        JSONObject content = new JSONObject();
        JSONArray customizations = new JSONArray();
        try {
            for (String name : this.getCache().getkeySet()) {
                JSONObject customization = new JSONObject();
                customization.put(NAME, (Object)name);
                customizations.add((Object)customization);
            }
            content.put(this.getContainerName(), (Collection)customizations);
        }
        catch (JSONException ex) {
            String msg = "Error retrieving customization names while parsing JSON";
            LOGGER.error(msg);
            throw new ESException(msg);
        }
        return content;
    }

    protected void deleteCustomization(String name) throws ESException {
        Lock writeLock = this.getLock().writeLock();
        writeLock.lock();
        try {
            this.deleteDirectory(name);
            this.parseSpecs();
        }
        finally {
            writeLock.unlock();
        }
    }

    protected byte[] getZip(String name) throws ESException {
        String cacheKey = this.cacheKeyGenerator.getCacheKey(name, this.httpServletRequest);
        if (this.getCache().get(cacheKey) == null) {
            return null;
        }
        String path = this.getCustomizationDirPath() + File.separator + name;
        return this.zipHandler.zipDirectory(new File(path), this.getContainerName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject upload(String name, InputStream zipStream) throws InvalidInputException, ESException {
        Lock writeLock = this.getLock().writeLock();
        writeLock.lock();
        try {
            JSONObject result;
            if (!this.extract(name, zipStream, this.getContainerName()) || !this.parseSpecs()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            this.cacheCustomization(this.getCache(), this.getExtractedFile());
            JSONObject jSONObject = result = JsonObjectUtils.convertToJSONObject(this.getSpec().getJsonSpec());
            return jSONObject;
        }
        finally {
            writeLock.unlock();
        }
    }

    private ReadWriteLock getLock() {
        return ExtensionUtils.getInstance().getLock();
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    protected abstract File getExtractedFile();

    public abstract Specification getSpec();

    public abstract String getContainerName();

    public abstract ExtensionArtifactCache<String, CacheArtifact> getCache();

    public abstract void updateCache(JsonObject var1, String var2);

    protected abstract Resource getResource(String var1);

    public abstract String getResourceType();

    public abstract boolean extract(String var1, InputStream var2, String var3) throws InvalidInputException;

    public abstract boolean parseSpecs();
}

