/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.loader;

import com.ibm.ba.glass.annotations.Loader;
import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.builtin.BuiltInThemes;
import com.ibm.ba.glass.cache.CacheKeyGenerator;
import com.ibm.ba.glass.defaults.DefaultTheme;
import com.ibm.ba.glass.loader.CurrentThemeLoader;
import com.ibm.ba.glass.resource.BaseJaxrsFileResource;
import com.ibm.ba.glass.resource.ThemeCssResource;
import com.ibm.ba.glass.resource.ThemeFavIconResource;
import com.ibm.ba.glass.resource.ThemeSpecResource;
import com.ibm.ba.glass.utils.CacheArtifact;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.ba.glass.utils.ExtensionUtils;
import com.ibm.bi.json.JsonObject;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.PathSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Loader(value="FileSystem")
public class FSCurrentThemeLoader
implements CurrentThemeLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FSCurrentThemeLoader.class);
    protected static final String THEMES = "themes";
    protected HttpServletRequest httpServletRequest;
    @Inject
    @Managed
    private CacheKeyGenerator cacheKeyGenerator;
    @Inject
    @Managed
    private Provider<BaseJaxrsFileResource> fileResources;
    @Inject
    private Provider<ThemeCssResource> cssResources;
    @Inject
    private Provider<ThemeFavIconResource> faviconResources;
    @Inject
    private Provider<ThemeSpecResource> specResources;
    @Inject
    private DefaultTheme defaultTheme;
    @Inject
    private BuiltInThemes builtInThemes;

    @Override
    public void setHttpServletRequest(HttpServletRequest request) {
        this.httpServletRequest = request;
    }

    @Override
    public BaseJaxrsFileResource getJaxrsFile(String fileName, List<PathSegment> pathSegmentList) {
        BaseJaxrsFileResource fileResource = (BaseJaxrsFileResource)this.fileResources.get();
        fileResource.initialize(THEMES, fileName, pathSegmentList);
        return fileResource;
    }

    @Override
    public ThemeSpecResource getThemeSpecResource(String themeName) {
        ThemeSpecResource specResource = (ThemeSpecResource)this.specResources.get();
        specResource.initialize(themeName);
        return specResource;
    }

    @Override
    public ThemeCssResource getThemeCssResource(String themeName) {
        ThemeCssResource cssResource = (ThemeCssResource)this.cssResources.get();
        cssResource.initialize(themeName);
        return cssResource;
    }

    @Override
    public ThemeFavIconResource getThemeFavIconResource(String currentTheme) {
        ThemeFavIconResource faviconResource = (ThemeFavIconResource)this.faviconResources.get();
        faviconResource.initialize(currentTheme, this.getThemeFavIconPath(currentTheme));
        return faviconResource;
    }

    public String getThemeFavIconPath(String name) {
        JsonObject images;
        if (this.builtInThemes.isBuiltIn(name)) {
            return null;
        }
        JsonObject defaultImages = this.defaultTheme.getSpec().getObject("images");
        JsonObject specJson = null;
        CacheArtifact cacheArtifact = this.getCacheArtifact(name);
        if (cacheArtifact != null) {
            specJson = cacheArtifact.getSpecData();
        }
        String theIcon = null;
        if (specJson != null && (images = specJson.getObject("images")) != null) {
            theIcon = images.getString("favicon");
            if (theIcon == null || theIcon.equals(defaultImages.getString("favicon"))) {
                theIcon = images.getString("brandIconSmall");
            }
            if (theIcon != null && !theIcon.equals(defaultImages.getString("brandIconSmall"))) {
                theIcon = theIcon.replace("v1/plugins/themes/current/", "");
            }
        }
        return theIcon;
    }

    private CacheArtifact getCacheArtifact(String customizationName) {
        try {
            String cacheKey = this.cacheKeyGenerator.getCacheKey(customizationName, this.httpServletRequest);
            return this.getExtensionUtils().getThemeCache().get(cacheKey);
        }
        catch (ESException error) {
            LOGGER.error("Unable to get cache key.");
            return null;
        }
    }

    protected ExtensionUtils getExtensionUtils() {
        return ExtensionUtils.getInstance();
    }
}

