/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.loader;

import com.ibm.ba.glass.annotations.Loader;
import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.cache.PerspectivesCache;
import com.ibm.ba.glass.cache.WhiteListCache;
import com.ibm.ba.glass.exception.InvalidInputException;
import com.ibm.ba.glass.loader.ExtensionLoader;
import com.ibm.ba.glass.loader.FSBaseLoader;
import com.ibm.ba.glass.resource.BaseJaxrsFileResource;
import com.ibm.ba.glass.resource.ExtensionSchema;
import com.ibm.ba.glass.resource.ExtensionSpecification;
import com.ibm.ba.glass.resource.Resource;
import com.ibm.ba.glass.resource.ResourceFile;
import com.ibm.ba.glass.resource.Specification;
import com.ibm.ba.glass.utils.CacheArtifact;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.ba.glass.utils.ExtensionArtifactCache;
import com.ibm.ba.glass.utils.ExtensionUtils;
import com.ibm.ba.glass.utils.GlassCommonMessageKeys;
import com.ibm.ba.glass.utils.JsonObjectUtils;
import com.ibm.ba.glass.utils.SpecUtils;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.PathSegment;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Loader(value="FileSystem")
public class FSExtensionLoader
extends FSBaseLoader
implements ExtensionLoader {
    private static final String RESOURCE_TYPE = "extension";
    private static final String MASTER = "master";
    private static final String MASTER_FILENAME = "master.json";
    public static final String EXTENSIONS = "extensions";
    public static final String EXTENSION_TYPE = "type";
    public static final int MIN_CACHE_SIZE = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(FSExtensionLoader.class);
    private ExtensionSpecification masterSpec = new ExtensionSpecification();
    private ExtensionSpecification uploadedSpec;
    private File extractedFile;
    private static String schema;
    private PerspectivesCache perspectivesCache;
    @Inject
    @Managed
    private Provider<BaseJaxrsFileResource> fileResources;

    @Inject
    public void setPerspectivesCache(@Managed PerspectivesCache perspectivesCache) {
        this.perspectivesCache = perspectivesCache;
    }

    @Override
    public boolean extract(String name, InputStream zipStream, String targetFolder) throws InvalidInputException {
        try {
            this.initializeSpec(zipStream, name);
            this.extractedFile = this.extractToFileSystem(targetFolder, this.getSpec().getName());
            return true;
        }
        catch (ESException e) {
            LOGGER.error("Failed to extract to file system.", (Throwable)e);
            return false;
        }
    }

    private void initializeSpec(InputStream zipStream, String name) throws ESException, InvalidInputException {
        try {
            JsonObject jsonSpec = this.getSpecFromZip();
            this.validateSpec(jsonSpec, name);
            this.uploadedSpec = new ExtensionSpecification(jsonSpec, name);
        }
        catch (ESException e) {
            throw new ESException("Error parsing specification.", e);
        }
    }

    public void validateSpec(JsonObject jsonSpec, String name) throws InvalidInputException {
        String nameInSpec = jsonSpec.getString("name");
        if (name != null && !name.equals(nameInSpec)) {
            throw new InvalidInputException(GlassCommonMessageKeys.INVALID_CUSTOMIZATION_NAME, nameInSpec);
        }
    }

    @Override
    public boolean parseSpecs() {
        boolean specFilesPresent = false;
        WhiteListCache whiteListCache = WhiteListCache.getInstance();
        whiteListCache.clearCache();
        try {
            this.perspectivesCache.initPerspectivesCache();
            List<ResourceFile> list = this.walkDirectory(this.getExtensionsRoot());
            for (ResourceFile res : list) {
                if (!res.isSpecFile()) continue;
                JsonObject jsonSpec = this.parseString(res.getResourceAsString());
                this.processSpec(jsonSpec);
                this.parseForWhiteList(jsonSpec, whiteListCache);
                this.perspectivesCache.cacheExtensionPerspectives(jsonSpec, res);
                specFilesPresent = true;
            }
            if (!specFilesPresent) {
                this.deleteMasterSpec();
            }
            this.perspectivesCache.injectPerspectiveDefinitions();
            whiteListCache.cacheTransientWhiteLists();
            this.postParseSpecsHook();
            return specFilesPresent;
        }
        catch (Exception e) {
            LOGGER.error("Error parsing specifications.", (Throwable)e);
            this.attemptDeleteDirectory();
            return false;
        }
    }

    private void attemptDeleteDirectory() {
        try {
            this.deleteDirectory(this.getSpec().getName());
        }
        catch (Exception error) {
            LOGGER.error("Error cleaning up directory.");
        }
    }

    private void parseForWhiteList(JsonObject spec, WhiteListCache cache) {
        ArrayList<String> urls = SpecUtils.parseUrlsFromSpec(spec);
        for (String url : urls) {
            if (url == null) continue;
            cache.addWhiteListItem("url", url);
        }
    }

    public void postParseSpecsHook() throws InvalidInputException {
    }

    public synchronized JsonObject getMasterSpec() throws ESException {
        JsonObject master = this.getMasterResource().getResourceAsJson();
        if (master == null) {
            master = this.masterSpec.getJsonSpec();
        }
        return master;
    }

    public synchronized Date getMasterSpecLastModified() throws ESException {
        Resource res = this.getMasterResource();
        if (res.exists()) {
            return res.getLastModified();
        }
        return null;
    }

    public synchronized void processSpec(JsonObject jsonSpec) throws ESException, InvalidInputException {
        this.masterSpec.merge(new ExtensionSpecification(jsonSpec, null));
        this.exportMasterSpec();
    }

    public synchronized void exportMasterSpec() throws ESException {
        Resource res = this.getMasterResource();
        res.update(this.masterSpec.getJsonSpec().toString());
    }

    public synchronized void deleteMasterSpec() {
        try {
            Resource res = this.getMasterResource();
            res.delete();
        }
        catch (ESException e) {
            LOGGER.error("Error deleting master spec.", (Throwable)e);
        }
    }

    private synchronized Resource getMasterResource() throws ESException {
        File extDir = this.createDirectory(false, this.getRootFolder(), EXTENSIONS);
        File masterDir = this.createDirectory(false, extDir.getAbsolutePath(), MASTER);
        StringBuilder masterPath = new StringBuilder(masterDir.getAbsolutePath()).append(File.separator).append(MASTER_FILENAME);
        return this.getResource(masterPath.toString());
    }

    @Override
    public void updateCache(JsonObject objectInfo, String cacheKey) {
        CacheArtifact artifact = new CacheArtifact(objectInfo);
        ExtensionArtifactCache<String, CacheArtifact> cache = this.getCache();
        cache.put(cacheKey, artifact);
        cache.put(EXTENSIONS, artifact);
    }

    @Override
    public void deleteFromCache(String name) throws ESException {
        String cacheKey;
        ExtensionArtifactCache<String, CacheArtifact> cache = this.getCache();
        if (cache.get(cacheKey = this.cacheKeyGenerator.getCacheKey(name, this.httpServletRequest)) != null) {
            Set<String> keys = cache.getkeySet();
            Iterator<String> it = keys.iterator();
            CacheArtifact latestArtifact = cache.get(it.next());
            while (it.hasNext()) {
                String key = it.next();
                CacheArtifact ca = cache.get(key);
                Date laDate = latestArtifact.getModificationTime();
                Date caDate = ca.getModificationTime();
                if (!this.isValidArtifact(latestArtifact, name)) {
                    latestArtifact = ca;
                    continue;
                }
                if (!this.isValidArtifact(ca, name) || !laDate.before(caDate)) continue;
                latestArtifact = ca;
            }
            cache.remove(cacheKey);
            if (cache.size() <= 1L) {
                cache.emptyCache();
            } else {
                cache.put(EXTENSIONS, latestArtifact);
            }
        }
    }

    private boolean isValidArtifact(CacheArtifact artifact, String name) {
        return artifact.getName().compareTo(name) != 0 && artifact.getName().compareTo(EXTENSIONS) != 0;
    }

    @Override
    public Specification getSpec() {
        return this.uploadedSpec;
    }

    @Override
    public String getContainerName() {
        return EXTENSIONS;
    }

    @Override
    public ExtensionArtifactCache<String, CacheArtifact> getCache() {
        return ExtensionUtils.getInstance().getExtensionCache();
    }

    @Override
    protected Resource getResource(String path) {
        return new ResourceFile(path);
    }

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    protected String getSchema() {
        if (schema == null) {
            schema = ExtensionSchema.load();
        }
        return schema;
    }

    @Override
    protected File getExtractedFile() {
        return this.extractedFile;
    }

    @Override
    public byte[] getExtensionZip(String extName) throws ESException {
        return this.getZip(extName);
    }

    @Override
    public JSONObject getExtensions() throws ESException {
        return this.buildCustomizationContent();
    }

    @Override
    public void deleteExtension(String extName) throws ESException {
        this.deleteCustomization(extName);
        super.deleteFromCache(extName);
    }

    @Override
    public JSONObject uploadExtension(String extName, InputStream zipStream) throws ESException, InvalidInputException {
        return this.upload(extName, zipStream);
    }

    public String getExtensionType(InputStream zipStream) throws InvalidInputException, ESException {
        JsonObject jsonSpec = this.getSpecFromZip();
        JsonArray extension = (JsonArray)jsonSpec.get(EXTENSIONS);
        return (String)((JsonObject)extension.get(0)).get(EXTENSION_TYPE);
    }

    @Override
    public BaseJaxrsFileResource getJaxrsFile(String fileName, List<PathSegment> pathSegmentList) {
        BaseJaxrsFileResource fileResource = (BaseJaxrsFileResource)this.fileResources.get();
        fileResource.initialize(EXTENSIONS, fileName, pathSegmentList);
        return fileResource;
    }

    @Override
    public JSONObject getMasterExtension() throws ESException {
        try {
            Date date = this.getMasterExtensionLastModified();
            if (date == null) {
                return null;
            }
            return JsonObjectUtils.convertToJSONObject(this.getMasterSpec());
        }
        catch (Exception ex) {
            String msg = "Cannot retrieve master extensions spec.";
            LOGGER.error(msg, (Throwable)ex);
            throw new ESException(msg);
        }
    }

    @Override
    public Date getMasterExtensionLastModified() throws ESException {
        Date result;
        try {
            result = this.getMasterSpecLastModified();
        }
        catch (Exception e) {
            String msg = "Error getting master extension last modified";
            LOGGER.error(msg, (Throwable)e);
            throw new ESException(msg);
        }
        return result;
    }

    @Override
    public void setHttpServletRequest(HttpServletRequest request) {
    }
}

