/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.loader;

import com.ibm.ba.glass.annotations.Loader;
import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.exception.JSONFormatException;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.loader.ContributionObject;
import com.ibm.ba.glass.loader.PerspectiveLoader;
import com.ibm.ba.glass.model.GFModelConfig;
import com.ibm.ba.glass.model.JSONBase;
import com.ibm.ba.glass.resource.Perspective;
import com.ibm.ba.glass.resource.RootFolder;
import com.ibm.ba.glass.utils.CustomPropertyUtils;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.ba.glass.utils.JsonObjectUtils;
import com.ibm.ba.glass.utils.ResourceBundleLoader;
import com.ibm.bi.json.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Loader(value="FileSystem")
public class FSPerspectiveLoader
extends JSONBase
implements PerspectiveLoader {
    public static final String PERSPECTIVES_DIR_LOOKUP = "com.ibm.ba.PerspectivesDirectory";
    private static final Logger LOGGER = LoggerFactory.getLogger(FSPerspectiveLoader.class);
    private static final String CONTRIB_DIR = "contrib";
    private static final String APPLICATION_FILE = "application.json";
    private static final String JSON_FILE_EXT = "json";
    private static final String KEY_LOCALIZATION_FILE_NAME_REF = "localizationFileName";
    private static final String RESOURCE_DIR = "locales";
    private static final String KEY_EXTENSIONS = "extensions";
    private static final String KEY_PERSPECTIVE = "perspective";
    private static final String KEY_INHERITS = "inherits";
    private static final String KEY_EXCLUDE_COMMON = "excludeCommon";
    private static final String KEY_NAME = "name";
    private GFModelConfig config;
    private String configRoot;
    private Boolean excludeCommon;
    private ArrayList<List<ContributionObject>> contribObjects = null;
    @Inject
    @Managed
    private RootFolder rootFolder;
    @Inject
    private ResourceBundleLoader resourceBundleLoader;

    public String getPerspectiveFilesLocation() {
        String defaultLocation = this.getDefaultPerspectiveFilesLocation();
        return CustomPropertyUtils.readCustomProperty(PERSPECTIVES_DIR_LOOKUP, defaultLocation);
    }

    private String getDefaultPerspectiveFilesLocation() {
        try {
            return this.rootFolder.getRootFolderPath() + File.separator + "perspectives";
        }
        catch (ESException error) {
            LOGGER.error("Unable to get root folder.");
            return null;
        }
    }

    @Override
    public ArrayList<Perspective> getEmbeddedPerspectivesList() throws JSONFormatException {
        ArrayList<Perspective> perspectives = new ArrayList<Perspective>();
        String perspectivesDirectoryString = this.getPerspectiveFilesLocation();
        Path perspectivesDirectoryPath = Paths.get(perspectivesDirectoryString, new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(perspectivesDirectoryPath);){
            for (Path directory : directoryStream) {
                Perspective perspective = this.getPerspectiveFromDirectory(directory);
                if (perspective == null) continue;
                perspectives.add(perspective);
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to read list of embedded perspectives", (Throwable)ex);
        }
        return perspectives;
    }

    private Perspective getPerspectiveFromDirectory(Path directory) throws JSONFormatException {
        Path applicationFile = directory.resolve(APPLICATION_FILE);
        if (Files.exists(applicationFile, new LinkOption[0]) && Files.isRegularFile(applicationFile, new LinkOption[0])) {
            JsonObject jsonSpec = JsonObjectUtils.loadFromFile(applicationFile.toFile());
            JSONObject perspectiveSpec = JsonObjectUtils.convertToJSONObject(jsonSpec);
            String perspectiveName = directory.getFileName().toString();
            return new Perspective(perspectiveName, perspectiveSpec);
        }
        return null;
    }

    @Override
    public void load(GFModelConfig config) throws ResourceNotFoundException {
        block5: {
            this.configRoot = this.getPerspectiveFilesLocation();
            this.config = config;
            this.excludeCommon = null;
            this.contribObjects = new ArrayList();
            ArrayList<String> inheritanceChain = new ArrayList<String>();
            try {
                String perspective = config.getPerspectiveId();
                ContributionObject application = this.getApplication(perspective);
                if (application != null) {
                    this.loadPerspectiveContributions(perspective, application, inheritanceChain);
                    if (this.excludeCommon == null || !this.excludeCommon.booleanValue()) {
                        this.loadCommonContributions();
                    }
                    break block5;
                }
                throw new ResourceNotFoundException("Perspective not found: " + config.getPerspectiveId());
            }
            catch (IOException | JSONException e) {
                if (e instanceof ResourceNotFoundException) {
                    throw (ResourceNotFoundException)e;
                }
                throw new RuntimeException("Invalid json enountered while loading the perspective", e);
            }
        }
    }

    @Override
    public List<List<ContributionObject>> getContributionObjects() {
        return this.contribObjects;
    }

    protected void loadCommonContributions() throws JSONException {
        ContributionObject commonExtContrib = this.getExtensionContribution("common", false);
        this.addContribGroup(commonExtContrib, true);
        this.addContribGroup(this.getCommonFolderContributions(), true);
    }

    private void loadPerspectiveContributions(String perspective, ContributionObject application, ArrayList<String> inheritanceChain) {
        try {
            if (this.excludeCommon == null) {
                this.excludeCommon = this.getJsonProperty(application.getJson(), KEY_EXCLUDE_COMMON, Boolean.class, null);
            }
            inheritanceChain.add(perspective);
            String superPerspective = this.getJsonProperty(application.getJson(), KEY_INHERITS, String.class, null);
            if (superPerspective != null) {
                if (inheritanceChain.contains(superPerspective)) {
                    throw new RuntimeException("Recursive inheritance error: " + perspective);
                }
                ContributionObject superApplication = this.getApplication(superPerspective);
                this.loadPerspectiveContributions(superPerspective, superApplication, inheritanceChain);
            }
            ArrayList<ContributionObject> perspectiveContributions = new ArrayList<ContributionObject>();
            perspectiveContributions.add(application);
            if (application.isExtension()) {
                this.addContribGroup(perspectiveContributions);
            } else {
                perspectiveContributions.addAll(this.getContribFolderContributions(perspective));
                this.addContribGroup(perspectiveContributions);
                ContributionObject extContrib = this.getExtensionContribution(perspective, false);
                if (extContrib != null) {
                    this.addContribGroup(extContrib, false);
                }
            }
        }
        catch (IOException | JSONException error) {
            throw new RuntimeException(error);
        }
    }

    private void addContribGroup(ContributionObject contrib, boolean isCommon) {
        if (contrib != null) {
            ArrayList<ContributionObject> contribGroup = new ArrayList<ContributionObject>();
            contribGroup.add(contrib);
            this.addContribGroup(contribGroup, isCommon);
        }
    }

    private void addContribGroup(List<ContributionObject> contribGroup) {
        this.addContribGroup(contribGroup, false);
    }

    private void addContribGroup(List<ContributionObject> contribGroup, boolean isCommon) {
        if (contribGroup != null && contribGroup.size() > 0) {
            if (isCommon) {
                this.contribObjects.add(0, contribGroup);
            } else {
                this.contribObjects.add(contribGroup);
            }
        }
    }

    private List<ContributionObject> getCommonFolderContributions() throws JSONException {
        File commonDir = new File(this.configRoot, "common");
        return this.getContributions(commonDir, false);
    }

    private List<ContributionObject> getContribFolderContributions(String perspective) throws JSONException {
        File perspectiveRoot = new File(this.configRoot, perspective);
        File pluginDir = new File(perspectiveRoot, CONTRIB_DIR);
        return this.getContributions(pluginDir, false);
    }

    private File getApplicationFile(String perspective) {
        File perspectiveRoot = new File(this.configRoot, perspective);
        File baseFile = new File(perspectiveRoot.getAbsolutePath(), APPLICATION_FILE);
        return baseFile;
    }

    protected ContributionObject getApplication(String perspective) throws IOException, JSONException {
        ContributionObject contrib = null;
        File applicationFile = this.getApplicationFile(perspective);
        contrib = applicationFile.exists() ? this.getContribution(applicationFile, true) : this.getExtensionContribution(perspective, true);
        return contrib;
    }

    private ContributionObject getContribution(File file, boolean isApplication) throws JSONException, IOException {
        Boolean isDefaultMessageFile = true;
        try (FileInputStream in = new FileInputStream(file);){
            JSONObject json = new JSONObject((InputStream)in);
            String simpleFileName = file.getName();
            int pos = simpleFileName.lastIndexOf(46);
            if (pos >= 0) {
                simpleFileName = simpleFileName.substring(0, pos);
            }
            if (json.containsKey((Object)KEY_LOCALIZATION_FILE_NAME_REF)) {
                simpleFileName = json.getString(KEY_LOCALIZATION_FILE_NAME_REF);
                isDefaultMessageFile = false;
            }
            String parentPath = file.getParent();
            String rootPath = this.configRoot;
            String relativePath = parentPath.substring(parentPath.indexOf(rootPath) + rootPath.length() + 1);
            String bundlePath = relativePath + File.separator + RESOURCE_DIR + File.separator + simpleFileName;
            ResourceBundle resourceBundle = this.loadResourceBundle(bundlePath, isDefaultMessageFile);
            ContributionObject contributionObject = new ContributionObject(json, isApplication, resourceBundle, false);
            return contributionObject;
        }
    }

    private List<ContributionObject> getContributions(File pluginDir, boolean isApplication) {
        File[] filesList;
        ArrayList<ContributionObject> contribs = new ArrayList<ContributionObject>();
        if (pluginDir.exists() && (filesList = pluginDir.listFiles()) != null) {
            for (File file : filesList) {
                if (!this.isJsonFile(file)) continue;
                try {
                    ContributionObject contrib = this.getContribution(file, isApplication);
                    contribs.add(contrib);
                }
                catch (IOException | JSONException e) {
                    this.logger.logException((Exception)e);
                }
            }
        }
        return contribs;
    }

    private boolean isJsonFile(File file) {
        String fileName;
        String fileExtension;
        return file.isFile() && JSON_FILE_EXT.equals(fileExtension = FilenameUtils.getExtension((String)(fileName = file.getName())));
    }

    private ResourceBundle loadResourceBundle(String bundlePath, boolean isDefaultMessageFile) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this.resourceBundleLoader.load(this.getPerspectiveFilesLocation(), bundlePath, this.config.getRequestLocale());
        }
        catch (MissingResourceException mre) {
            String message = "parseFileContribution: Did not find message file: ";
            if (isDefaultMessageFile) {
                this.logger.logDebug(message + bundlePath, mre.getMessage());
            }
            Exception ex = new Exception(message + bundlePath, mre);
            this.logger.logException(ex);
        }
        return resourceBundle;
    }

    private ResourceBundle loadExtensionResourceBundle(String name) {
        ResourceBundle resourceBundle = null;
        String rootFolderPath = "";
        String resourceFolderPath = name + File.separator + RESOURCE_DIR;
        try {
            rootFolderPath = this.rootFolder.getExtensionsFolderPath();
        }
        catch (ESException e) {
            this.logger.logException(e);
            return resourceBundle;
        }
        if (new File(rootFolderPath + File.separator + resourceFolderPath).isDirectory()) {
            try {
                resourceBundle = this.resourceBundleLoader.load(rootFolderPath, resourceFolderPath + File.separator + name, this.config.getRequestLocale());
            }
            catch (Exception e) {
                Exception ex = new Exception("Unable to load resourceBundle for extension " + name, e);
                this.logger.logException(ex);
            }
        }
        return resourceBundle;
    }

    private ContributionObject getExtensionContribution(String perspective, boolean isApplication) {
        ContributionObject contrib = null;
        JSONArray extensions = this.getJsonProperty(this.config.getExtensions(), KEY_EXTENSIONS, JSONArray.class, perspective);
        if (extensions != null) {
            for (int i = 0; i < extensions.length(); ++i) {
                try {
                    JSONObject contribJson = extensions.getJSONObject(i);
                    String contribPerspective = this.getJsonProperty(contribJson, KEY_PERSPECTIVE, String.class, null);
                    if (!perspective.equals(contribPerspective)) continue;
                    contrib = new ContributionObject(contribJson, isApplication, this.loadExtensionResourceBundle(contribJson.getString(KEY_NAME)), true);
                    break;
                }
                catch (JSONException e) {
                    Exception ex = new Exception("Error processing extension plugin " + i + ". Skipping...", e);
                    this.logger.logException(ex);
                }
            }
        }
        return contrib;
    }
}

