/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.loader;

import com.ibm.ba.glass.annotations.Loader;
import com.ibm.ba.glass.defaults.DefaultTheme;
import com.ibm.ba.glass.exception.InvalidInputException;
import com.ibm.ba.glass.loader.FSBaseLoader;
import com.ibm.ba.glass.loader.ThemeLoader;
import com.ibm.ba.glass.resource.Palette;
import com.ibm.ba.glass.resource.Resource;
import com.ibm.ba.glass.resource.ResourceFile;
import com.ibm.ba.glass.resource.Specification;
import com.ibm.ba.glass.resource.ThemeSchema;
import com.ibm.ba.glass.resource.ThemeSpecification;
import com.ibm.ba.glass.utils.CacheArtifact;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.ba.glass.utils.ExtensionArtifactCache;
import com.ibm.ba.glass.utils.ExtensionUtils;
import com.ibm.bi.json.JsonObject;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Loader(value="FileSystem")
public class FSThemeLoader
extends FSBaseLoader
implements ThemeLoader {
    private static final String RESOURCE_TYPE = "theme";
    private static final String CSS = "css";
    private static final String PALETTE_CSS = "palette.css";
    public static final String THEMES = "themes";
    public static final String PROPERTY_BRAND_TEXT = "brandText";
    public static final String PROPERTY_BRAND_TEXT_SMALL = "brandTextSmall";
    private static final Logger LOGGER = LoggerFactory.getLogger(FSThemeLoader.class);
    private ThemeSpecification spec;
    private File extractedFile;
    @Inject
    private DefaultTheme defaultTheme;
    @Inject
    private ThemeSchema themeSchema;

    private void initializeSpec(InputStream zipStream, String name) throws ESException, InvalidInputException {
        try {
            this.spec = new ThemeSpecification(this.getSpecFromZip(), name);
        }
        catch (ESException e) {
            throw new ESException("Error parsing specification.", e);
        }
    }

    @Override
    public boolean extract(String name, InputStream zipStream, String targetFolder) throws InvalidInputException {
        try {
            this.initializeSpec(zipStream, name);
            this.extractedFile = this.extractToFileSystem(targetFolder, this.spec.getName());
            this.generatePaletteFile(this.extractedFile.getAbsolutePath());
            this.updateSpecFile(this.extractedFile.getAbsolutePath());
            return true;
        }
        catch (ESException e) {
            LOGGER.error("Failed to extract to file system.", (Throwable)e);
            return false;
        }
    }

    @Override
    public JSONObject getThemes() throws ESException {
        return this.buildCustomizationContent();
    }

    @Override
    public byte[] getThemeZip(String themeName) throws ESException {
        return this.getZip(themeName);
    }

    @Override
    public JSONObject uploadTheme(String themeName, InputStream zipStream) throws ESException, InvalidInputException {
        return this.upload(themeName, zipStream);
    }

    @Override
    public void deleteTheme(String themeName) throws ESException {
        this.deleteCustomization(themeName);
        this.deleteFromCache(themeName);
    }

    private void generatePaletteFile(String dirPath) throws ESException {
        try {
            Palette palette = this.createPalette();
            palette.initialize(this.getThemeSpec() != null ? this.getThemeSpec().getJsonSpec() : null);
            String css = palette.generateCSS();
            File dir = this.createDirectory(true, dirPath, CSS);
            StringBuilder filePath = new StringBuilder(dir.getAbsolutePath()).append(File.separator).append(PALETTE_CSS);
            Resource res = this.getResource(filePath.toString());
            res.update(css);
        }
        catch (ESException e) {
            throw new ESException("Failed to generate theme palette.", e);
        }
    }

    @Override
    public Specification getSpec() {
        return this.spec;
    }

    @Override
    public String getContainerName() {
        return THEMES;
    }

    @Override
    protected File getExtractedFile() {
        return this.extractedFile;
    }

    @Override
    public ExtensionArtifactCache<String, CacheArtifact> getCache() {
        return ExtensionUtils.getInstance().getThemeCache();
    }

    @Override
    protected Resource getResource(String path) {
        return new ResourceFile(path);
    }

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    protected Palette createPalette() {
        return new Palette();
    }

    protected ThemeSpecification getThemeSpec() {
        return this.spec;
    }

    @Override
    public void updateCache(JsonObject objectInfo, String cacheKey) {
        CacheArtifact artifact = this.getThemeSpec() == null ? new CacheArtifact(objectInfo) : new CacheArtifact(objectInfo, this.getThemeSpec().getJsonSpec());
        this.getCache().put(cacheKey, artifact);
    }

    @Override
    protected CacheArtifact createCacheArtifact(JsonObject objectInfo) {
        try {
            JsonObject uploadedThemeSpec = this.getRawSpec();
            JsonObject defaultThemeSpec = this.defaultTheme.getSpec();
            JsonObject spec = FSThemeLoader.mergeSpecs(defaultThemeSpec, uploadedThemeSpec);
            return new CacheArtifact(objectInfo, spec);
        }
        catch (InvalidInputException | ESException error) {
            LOGGER.error("Error creating Theme Cache Artifact");
            return new CacheArtifact(objectInfo);
        }
    }

    protected JsonObject getRawSpec() throws ESException, InvalidInputException {
        return super.getSpecFromZip();
    }

    @Override
    protected JsonObject getSpecFromZip() throws ESException, InvalidInputException {
        JsonObject theme = this.getRawSpec();
        JsonObject defaultThemeSpec = this.defaultTheme.getSpec();
        FSThemeLoader.setIconPath(theme);
        return FSThemeLoader.mergeSpecs(defaultThemeSpec, theme);
    }

    private static JsonObject mergeSpecs(JsonObject base, JsonObject top) throws ESException {
        JsonObject result = FSThemeLoader.mergeSpecsRecursively(base, top);
        if (top.containsKey((Object)PROPERTY_BRAND_TEXT) && !top.containsKey((Object)PROPERTY_BRAND_TEXT_SMALL)) {
            result.put(PROPERTY_BRAND_TEXT_SMALL, (Object)top.getString(PROPERTY_BRAND_TEXT));
        }
        return result;
    }

    private static JsonObject mergeSpecsRecursively(JsonObject base, JsonObject top) throws ESException {
        JsonObject result = FSThemeLoader.duplicate(base);
        for (Map.Entry e : top.entrySet()) {
            if (e.getValue() instanceof JsonObject && result.get((String)e.getKey()) instanceof JsonObject) {
                JsonObject baseChild = result.getObject((String)e.getKey());
                JsonObject topChild = top.getObject((String)e.getKey());
                result.put((String)e.getKey(), (Object)FSThemeLoader.mergeSpecsRecursively(baseChild, topChild));
                continue;
            }
            result.put((String)e.getKey(), e.getValue());
        }
        return result;
    }

    private static JsonObject duplicate(JsonObject source) throws ESException {
        JsonObject result = new JsonObject();
        for (Map.Entry e : source.entrySet()) {
            if (e.getValue() instanceof JsonObject) {
                JsonObject child = source.getObject((String)e.getKey());
                result.put((String)e.getKey(), (Object)FSThemeLoader.duplicate(child));
                continue;
            }
            result.put((String)e.getKey(), e.getValue());
        }
        return result;
    }

    private void updateSpecFile(String dirPath) throws ESException {
        try {
            ThemeSpecification specification = this.getThemeSpec();
            if (specification != null) {
                JsonObject themeSpec = specification.getJsonSpec();
                String specTxt = themeSpec.toString();
                StringBuilder filePath = new StringBuilder(dirPath).append(File.separator).append("spec.json");
                Resource res = this.getResource(filePath.toString());
                res.update(specTxt);
            }
        }
        catch (ESException e) {
            throw new ESException("Failed to update theme spec.json.", e);
        }
    }

    @Override
    public boolean parseSpecs() {
        return true;
    }

    private static void setIconPath(JsonObject themeJson) {
        if (themeJson == null) {
            LOGGER.error("Theme JsonObject is null when setting icon paths.");
            return;
        }
        JsonObject images = (JsonObject)themeJson.get("images");
        if (images != null) {
            for (Map.Entry entry : images.entrySet()) {
                String value = (String)entry.getValue();
                if (!FSThemeLoader.isImage(value)) continue;
                value = "v1/plugins/themes/current/" + value;
                entry.setValue(value);
            }
        }
    }

    private static boolean isImage(String fileName) {
        Pattern pattern = Pattern.compile("([^\\s]+(\\.(jpg|jpeg|png|gif|svg))$)", 2);
        Matcher matcher = pattern.matcher(fileName);
        return matcher.matches();
    }

    @Override
    protected String getSchema() {
        return this.themeSchema.getSchema();
    }
}

