/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.model;

import com.ibm.ba.glass.model.GFUIElement;
import com.ibm.ba.glass.utils.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class GFAction
extends GFUIElement {
    private static final String JSON_SECTION_KEY = "actions";
    private static final String JSON_KEY_ITEMS = "items";
    private static final String JSON_KEY_LENSABLE = "lensable";
    private static final String JSON_KEY_CONTROLLER = "controller";
    private static final String JSON_KEY_WEIGHT = "weight";
    private static final String JSON_KEY_LABEL = "label";
    private static final String JSON_KEY_ENV = "environment";
    private List<ActionItem> items = new ArrayList<ActionItem>();
    private String label;
    private JSONObject environment;

    @Override
    protected String getSectionKey() {
        return JSON_SECTION_KEY;
    }

    @Override
    public void initialize(String id, String featureId, JSONObject contents, Logger useLogger) {
        super.initialize(id, featureId, contents, useLogger);
        this.label = this.getJsonProperty(contents, JSON_KEY_LABEL, String.class, id + ":" + JSON_KEY_LABEL);
        this.environment = this.getJsonProperty(contents, JSON_KEY_ENV, JSONObject.class, id + ":" + JSON_KEY_ENV);
        List<JSONObject> jsonItems = this.getJsonArray(contents, JSON_KEY_ITEMS, JSONObject.class, id);
        if (jsonItems != null) {
            for (JSONObject jsonItem : jsonItems) {
                String itemController = this.getJsonProperty(jsonItem, JSON_KEY_CONTROLLER, String.class, id + ":" + JSON_KEY_CONTROLLER);
                Integer itemWeight = this.getJsonProperty(jsonItem, JSON_KEY_WEIGHT, Integer.class, id + ":" + JSON_KEY_CONTROLLER + ":" + JSON_KEY_WEIGHT);
                String itemLabel = this.getJsonProperty(jsonItem, JSON_KEY_LABEL, String.class, id + ":" + JSON_KEY_CONTROLLER + ":" + JSON_KEY_LABEL);
                Boolean itemLensable = this.getJsonProperty(jsonItem, JSON_KEY_LENSABLE, Boolean.class, id + ":" + JSON_KEY_CONTROLLER + ":" + JSON_KEY_LENSABLE);
                ActionItem actionItem = new ActionItem(itemController, itemWeight, itemLabel, itemLensable);
                this.items.add(actionItem);
            }
        }
    }

    public List<ActionItem> getItems() {
        return this.items;
    }

    public JSONObject getEnv() {
        return this.environment;
    }

    public String getLabel() {
        return this.label;
    }

    public GFAction copy() {
        GFAction action = new GFAction();
        action.id = this.id;
        action.containerId = this.containerId;
        action.label = this.label;
        action.isLensable = this.isLensable;
        if (this.environment != null) {
            action.environment = (JSONObject)this.environment.clone();
        }
        action.items = new ArrayList<ActionItem>();
        for (ActionItem item : this.items) {
            action.items.add(item.copy());
        }
        return action;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jsonAction = new JSONObject();
        jsonAction.put("id", (Object)this.id);
        JSONArray jsonItems = new JSONArray();
        jsonAction.put(JSON_KEY_ITEMS, (Collection)jsonItems);
        if (this.label != null) {
            jsonAction.put(JSON_KEY_LABEL, (Object)this.label);
        }
        if (this.isLensable != null) {
            jsonAction.put(JSON_KEY_LENSABLE, (Object)this.isLensable);
        }
        if (this.environment != null) {
            jsonAction.put(JSON_KEY_ENV, this.environment.clone());
        }
        for (ActionItem item : this.items) {
            JSONObject jsonController = new JSONObject();
            jsonItems.add((Object)jsonController);
            jsonController.put(JSON_KEY_CONTROLLER, (Object)item.controller);
            jsonController.put(JSON_KEY_WEIGHT, (Object)item.weight);
            if (item.label != null) {
                jsonController.put(JSON_KEY_LABEL, (Object)item.label);
            }
            if (item.isLensable == null) continue;
            jsonController.put(JSON_KEY_LENSABLE, (Object)item.isLensable);
        }
        return jsonAction;
    }

    public static class ActionItem {
        private String controller;
        private Integer weight;
        private String label;
        private Boolean isLensable;

        public ActionItem(String controller, Integer weight, String label, Boolean isLensable) {
            this.controller = controller;
            this.weight = weight;
            this.label = label;
            this.isLensable = isLensable;
        }

        public ActionItem copy() {
            return new ActionItem(this.controller, this.weight, this.label, this.isLensable);
        }

        public String getController() {
            return this.controller;
        }

        public Integer getWeight() {
            return this.weight;
        }

        public String getLabel() {
            return this.label;
        }

        public Boolean getIsLensable() {
            return this.isLensable;
        }
    }
}

