/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.model;

import com.ibm.ba.glass.model.GFCollectionItem;
import com.ibm.ba.glass.model.GFUIElement;
import com.ibm.ba.glass.utils.Logger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class GFCollectionContainer
extends GFUIElement {
    private static final String JSON_SECTION_KEY = "collectionContainers";
    public static final String JSON_KEY_ITEMS = "items";
    private List<GFCollectionItem> items;

    @Override
    protected String getSectionKey() {
        return JSON_SECTION_KEY;
    }

    @Override
    public void initialize(String id, String featureId, JSONObject contents, Logger useLogger) {
        super.initialize(id, featureId, contents, useLogger);
        try {
            if (contents.has(JSON_KEY_ITEMS)) {
                this.items = this.parseElementList(contents.getJSONArray(JSON_KEY_ITEMS), GFCollectionItem.class, featureId, featureId + ":" + JSON_KEY_ITEMS);
                contents.remove((Object)JSON_KEY_ITEMS);
            } else {
                this.items = new ArrayList<GFCollectionItem>();
            }
        }
        catch (JSONException e) {
            this.logger.logException((Exception)((Object)e));
        }
    }

    @Override
    public JSONObject write(JSONObject json) throws JSONException {
        JSONObject result = super.write(json);
        for (GFCollectionItem item : this.items) {
            item.write(result);
        }
        return result;
    }

    public void addItem(GFCollectionItem jsonItem) {
        this.items.add(jsonItem);
    }

    public List<GFCollectionItem> getItems() {
        return this.items;
    }

    public void filterCollectionItems(List<String> excludedItems) {
        ArrayList<GFCollectionItem> itemsToRemove = new ArrayList<GFCollectionItem>();
        for (GFCollectionItem item : this.items) {
            if (!excludedItems.contains(item.getId())) continue;
            itemsToRemove.add(item);
        }
        this.items.removeAll(itemsToRemove);
    }
}

