/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.model;

import com.ibm.ba.glass.model.GFAction;
import com.ibm.ba.glass.model.GFCollectionContainer;
import com.ibm.ba.glass.model.GFCollectionItem;
import com.ibm.ba.glass.model.GFToolBar;
import com.ibm.ba.glass.model.GFToolItem;
import com.ibm.ba.glass.model.GFToolItemGroup;
import com.ibm.ba.glass.model.GFToolMenuItem;
import com.ibm.ba.glass.model.JSONBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.json.JSONObject;

public class GFFeature
extends JSONBase {
    private String featureId;
    private Boolean isLensable;
    private List<GFToolBar> toolBars;
    private List<GFToolItemGroup> toolItemGroups;
    private List<GFToolItem> toolItems;
    private List<GFToolMenuItem> toolMenuItems;
    private List<GFToolItem> contextMenus;
    private List<GFAction> defaultActions;
    private List<GFCollectionContainer> collectionContainers;
    private JSONObject content;
    private List<String> cssStyles;
    private List<String> svgImages;
    private JSONObject featureJSON;
    private ResourceBundle resourceBundle;

    public GFFeature(JSONObject featureJSON, ResourceBundle resourceBundle) {
        this.featureJSON = featureJSON;
        this.resourceBundle = resourceBundle;
        this.featureId = this.getJsonProperty(featureJSON, "id", String.class, null);
        this.isLensable = this.getJsonProperty(featureJSON, "lensable", Boolean.class, null);
    }

    public JSONObject getJson() {
        return this.featureJSON;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public List<GFToolBar> getToolbars() {
        return this.toolBars;
    }

    public void setToolbars(List<GFToolBar> toolBars) {
        this.toolBars = toolBars;
    }

    public List<GFToolItemGroup> getToolItemGroups() {
        return this.toolItemGroups;
    }

    public void setToolItemGroups(List<GFToolItemGroup> toolItemGroups) {
        this.toolItemGroups = toolItemGroups;
    }

    public List<GFToolItem> getToolItems() {
        return this.toolItems;
    }

    public void setToolItems(List<GFToolItem> toolItems) {
        this.toolItems = toolItems;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public Boolean getIsLensable() {
        return this.isLensable;
    }

    public List<GFToolMenuItem> getToolMenuItems() {
        return this.toolMenuItems;
    }

    public void addToolMenuItems(List<GFToolMenuItem> toolItems) {
        if (toolItems == null) {
            return;
        }
        if (this.toolMenuItems == null) {
            this.toolMenuItems = new ArrayList<GFToolMenuItem>();
        }
        this.toolMenuItems.addAll(toolItems);
    }

    public List<String> getCssStyles() {
        return this.cssStyles;
    }

    public void setCssStyles(List<String> cssStyles) {
        this.cssStyles = cssStyles;
    }

    public List<String> getSvgImages() {
        return this.svgImages;
    }

    public void setSvgImages(List<String> value) {
        this.svgImages = value;
    }

    public List<GFToolItem> getContextMenus() {
        return this.contextMenus;
    }

    public void setContextMenus(List<GFToolItem> contextMenus) {
        this.contextMenus = contextMenus;
    }

    public List<GFAction> getDefaultActions() {
        return this.defaultActions;
    }

    public void setDefaultActions(List<GFAction> defaultActions) {
        this.defaultActions = defaultActions;
    }

    public JSONObject getContent() {
        return this.content;
    }

    public void setContent(JSONObject content) {
        this.content = content;
    }

    public List<GFCollectionContainer> getCollectionContainers() {
        return this.collectionContainers;
    }

    public void setCollectionContainers(List<GFCollectionContainer> containers) {
        this.collectionContainers = containers;
    }

    public void addCollectionItems(List<GFCollectionItem> items) {
        if (items == null || items.isEmpty() || this.collectionContainers == null) {
            return;
        }
        HashMap<String, GFCollectionContainer> containerById = new HashMap<String, GFCollectionContainer>();
        for (GFCollectionItem item : items) {
            GFCollectionContainer container = (GFCollectionContainer)containerById.get(item.getContainerId());
            if (container == null) {
                container = this.findCollectionContainer(this.collectionContainers, item.getContainerId());
            }
            if (container == null) continue;
            if (!containerById.containsKey(container.getId())) {
                containerById.put(container.getId(), container);
            }
            container.addItem(item);
        }
    }

    private GFCollectionContainer findCollectionContainer(List<GFCollectionContainer> containers, String id) {
        for (GFCollectionContainer container : containers) {
            if (!container.getId().equals(id)) continue;
            return container;
        }
        return null;
    }
}

