/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.model;

import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.loader.ContributionObject;
import com.ibm.ba.glass.loader.PerspectiveLoader;
import com.ibm.ba.glass.model.GFAction;
import com.ibm.ba.glass.model.GFCollectionContainer;
import com.ibm.ba.glass.model.GFCollectionItem;
import com.ibm.ba.glass.model.GFFeature;
import com.ibm.ba.glass.model.GFModelConfig;
import com.ibm.ba.glass.model.GFPerspective;
import com.ibm.ba.glass.model.GFToolBar;
import com.ibm.ba.glass.model.GFToolItem;
import com.ibm.ba.glass.model.GFToolItemGroup;
import com.ibm.ba.glass.model.GFToolMenuItem;
import com.ibm.ba.glass.model.GFUIElement;
import com.ibm.ba.glass.model.JSONBase;
import com.ibm.ba.glass.resource.Theme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class GFModel
extends JSONBase {
    private static final String KEY_CAPABILITIES = "capabilities";
    private static final String KEY_FEATURES = "features";
    private static final String KEY_TOOLBAR = "toolBars";
    private static final String KEY_ITEM_GROUP = "toolItemGroups";
    private static final String KEY_CONTEXT_MENU = "contextMenus";
    private static final String KEY_ITEM = "toolItems";
    private static final String KEY_LANGUAGE = "lang";
    private static final String KEY_MENU_ITEMS = "items";
    private static final String KEY_ITEM_CONTROLLER = "actionController";
    private static final String KEY_ITEM_CONTROLLER_CONFIG = "controllerConfig";
    private static final String KEY_CONTENT_REF = "content";
    private static final String TRANSLATE_INDICATOR = "%";
    private static final String NO_TRANSLATE_INDICATOR = "%%";
    private static final String THEME_INDICATOR = "theme.current.";
    private static final String KEY_WEIGHT = "weight";
    private static final String KEY_CONTENT = "content";
    private static final String KEY_TYPE = "type";
    private static final String KEY_MODULE = "module";
    private static final String KEY_LABEL = "label";
    private static final String KEY_ICON = "icon";
    private static final String KEY_OPTIONS = "options";
    private static final String KEY_ENVIRONMENT = "environment";
    private static final String KEY_SLIDEOUT = "slideout";
    private static final String KEY_CSS_STYLE = "cssStyles";
    private static final String KEY_SVG_IMAGES = "svgImages";
    private static final String KEY_EXCLUDED_FEATURES = "excludeFeatures";
    private static final String KEY_EXCLUDED_ITEMS = "excludeItems";
    private static final String KEY_FEATURE_ID = "featureId";
    private static final String KEY_DEFAULT_ACTIONS = "actions";
    private static final String KEY_ITEMS = "items";
    private static final String KEY_COLLECTION_CONTAINERS = "collectionContainers";
    private static final String KEY_COLLECTION_ITEMS = "collectionItems";
    private static final String CONTENTVIEW_V2_ADAPTOR_MODULE = "bi/glass/api/ExtensionViewAdaptor";
    private static final String TOOLITEM_MENU_ITEM = "MenuItem";
    private static final String[] MENUS = new String[]{"toolItems", "contextMenus"};
    private static final String TOP_CONTAINER_ID = "com.ibm.ba.glass.root";
    private Map<String, Map<String, List<GFUIElement>>> elementsById = new LinkedHashMap<String, Map<String, List<GFUIElement>>>();
    private static final String[] keysToMove = new String[]{"id", "label", "icon", "weight", "slideout", "options", "environment"};
    private JSONObject contentRef;
    private List<GFFeature> features = new ArrayList<GFFeature>();
    private Map<String, Boolean> featureIsLensableById = new HashMap<String, Boolean>();
    private List<String> excludedSharedFeatures = new ArrayList<String>();
    private List<String> excludedSharedItems = new ArrayList<String>();
    private GFModelConfig config;
    private List<GFCollectionItem> collectionItems = new ArrayList<GFCollectionItem>();
    private final GFPerspective perspective;
    private Map<String, String> itemContainerIds = new HashMap<String, String>();

    public GFModel() {
        this.perspective = new GFPerspective();
    }

    public JSONObject getCombinedJSON(GFModelConfig config, PerspectiveLoader loader) throws ResourceNotFoundException {
        this.initialize(config, loader);
        JSONObject result = new JSONObject();
        this.getCombinedJSONHelper(result, TOP_CONTAINER_ID);
        try {
            if (this.contentRef != null) {
                result.put("content", (Map)this.contentRef);
            }
            if (config.getRequestLocale() != null) {
                result.put(KEY_LANGUAGE, (Object)config.getRequestLocale().getLanguage());
            }
            this.perspective.write(result);
            if (this.features != null) {
                this.writeCssStyles(result);
                this.writeSvgImages(result);
                this.writeActions(result);
            }
            if (this.perspective.getCapabilities() != null) {
                result.put(KEY_CAPABILITIES, this.perspective.getCapabilities());
            }
        }
        catch (JSONException e) {
            this.logger.logException((Exception)((Object)e));
        }
        this.sortByWeight(result);
        return result;
    }

    private void getCombinedJSONHelper(JSONObject result, String id) {
        for (String featureId : this.elementsById.keySet()) {
            List<GFUIElement> elements;
            Map<String, List<GFUIElement>> featureElements = this.elementsById.get(featureId);
            if (featureElements == null || (elements = featureElements.remove(id)) == null) continue;
            for (GFUIElement element : elements) {
                try {
                    if (this.isElementExcluded(element)) continue;
                    element.setIsLensable(this.featureIsLensableById.get(featureId));
                    JSONObject elementJson = element.write(result);
                    if (elementJson == null) continue;
                    String elementId = element.getId();
                    this.getCombinedJSONHelper(elementJson, elementId);
                }
                catch (JSONException e) {
                    this.logger.logException((Exception)((Object)e));
                }
            }
        }
    }

    private boolean isElementExcluded(GFUIElement element) {
        boolean isExcluded = this.excludedSharedItems.contains(element.getId());
        if (!isExcluded && element instanceof GFCollectionContainer) {
            GFCollectionContainer container = (GFCollectionContainer)element;
            container.filterCollectionItems(this.excludedSharedItems);
        }
        return isExcluded;
    }

    private void writeCssStyles(JSONObject result) throws JSONException {
        ArrayList<String> cssStyles = new ArrayList<String>();
        for (GFFeature feature : this.features) {
            List<String> tmp = feature.getCssStyles();
            if (tmp == null) continue;
            cssStyles.addAll(tmp);
        }
        if (!cssStyles.isEmpty()) {
            Collections.sort(cssStyles);
            result.put(KEY_CSS_STYLE, cssStyles);
        }
    }

    private void writeSvgImages(JSONObject result) throws JSONException {
        ArrayList<String> svgImages = new ArrayList<String>();
        for (GFFeature feature : this.features) {
            List<String> tmp = feature.getSvgImages();
            if (tmp == null) continue;
            svgImages.addAll(tmp);
        }
        if (!svgImages.isEmpty()) {
            Collections.sort(svgImages);
            result.put(KEY_SVG_IMAGES, svgImages);
        }
    }

    private void writeActions(JSONObject result) throws JSONException {
        HashMap<String, GFAction> defaultActions = new HashMap<String, GFAction>();
        for (GFFeature feature : this.features) {
            List<GFAction> actions = feature.getDefaultActions();
            if (actions == null) continue;
            for (GFAction action : actions) {
                GFAction defaultAction;
                String actionId;
                if (action.getItems() == null || (actionId = action.getId()) == null) continue;
                if (defaultActions.containsKey(actionId)) {
                    defaultAction = (GFAction)defaultActions.get(actionId);
                    defaultAction.getItems().addAll(action.getItems());
                    continue;
                }
                defaultAction = action.copy();
                defaultActions.put(actionId, defaultAction);
            }
        }
        if (!defaultActions.isEmpty()) {
            JSONArray jsonDefaultActions = new JSONArray();
            result.put(KEY_DEFAULT_ACTIONS, (Collection)jsonDefaultActions);
            for (Map.Entry entry : defaultActions.entrySet()) {
                jsonDefaultActions.put((Map)((GFAction)entry.getValue()).toJSON());
            }
        }
    }

    private void initialize(GFModelConfig config, PerspectiveLoader loader) throws ResourceNotFoundException {
        this.config = config;
        Comparator<GFFeature> featureComparator = new Comparator<GFFeature>(){

            @Override
            public int compare(GFFeature feature1, GFFeature feature2) {
                return feature1.getFeatureId().compareTo(feature2.getFeatureId());
            }
        };
        ArrayList allFeatures = new ArrayList();
        for (List<ContributionObject> contributionGroup : loader.getContributionObjects()) {
            ArrayList<GFFeature> groupFeatures = new ArrayList<GFFeature>();
            for (ContributionObject contribution : contributionGroup) {
                List<GFFeature> contribFeatures = this.parseContribution(contribution);
                groupFeatures.addAll(contribFeatures);
            }
            groupFeatures.sort(featureComparator);
            allFeatures.addAll(groupFeatures);
        }
        Predicate<GFFeature> featurePredicate = feature -> this.excludedSharedFeatures.contains(feature.getFeatureId());
        allFeatures.removeIf(featurePredicate);
        for (GFFeature gfFeature : allFeatures) {
            this.parseFeature(gfFeature);
            this.features.add(gfFeature);
        }
        this.injectCollectionItems(this.features, this.collectionItems);
        this.buildLensableFeatureMap(this.features, this.featureIsLensableById);
    }

    private List<GFFeature> parseContribution(ContributionObject contribution) {
        String parseContext = "parseContribution";
        JSONObject json = contribution.getJson();
        ResourceBundle resourceBundle = contribution.getResourceBundle();
        ArrayList<GFFeature> result = new ArrayList<GFFeature>();
        if (contribution.isApplicationFile()) {
            this.perspective.read(json);
        }
        this.perspective.readContribution(json);
        JSONArray jsonFeatures = this.getJsonProperty(json, KEY_FEATURES, JSONArray.class, parseContext);
        if (jsonFeatures == null) {
            return result;
        }
        for (Object object : jsonFeatures) {
            JSONObject tempContentRef;
            if (!(object instanceof JSONObject)) {
                this.logger.logError("Expecting JSONObject, but got: " + object.toString(), parseContext);
                continue;
            }
            JSONObject featureJSON = (JSONObject)object;
            GFFeature feature = new GFFeature(featureJSON, resourceBundle);
            String featureId = feature.getFeatureId();
            if (featureId == null || this.excludedSharedFeatures.contains(featureId)) continue;
            if (contribution.isExtension()) {
                this.processExtensionFeature(featureJSON);
                this.parseActionsFromExtension(json, feature, parseContext);
            }
            if (contribution.isApplicationFile() && (tempContentRef = this.getJsonProperty(featureJSON, "content", JSONObject.class, parseContext)) != null) {
                if (this.contentRef == null) {
                    this.contentRef = tempContentRef;
                } else {
                    try {
                        this.merge(this.contentRef, tempContentRef);
                    }
                    catch (JSONException e) {
                        Exception ex = new Exception("Could not merge content.", e);
                        this.logger.logException(ex);
                    }
                }
            }
            this.registerExclusions(featureJSON);
            this.parseCssStyles(featureJSON, feature, parseContext);
            this.parseSvgImages(featureJSON, feature, parseContext);
            result.add(feature);
        }
        return result;
    }

    private void parseFeature(GFFeature feature) {
        JSONArray collectionItemsJson;
        JSONArray collectionContainers;
        JSONArray contributedDefaultActions;
        JSONArray toolBarItems;
        JSONArray contextMenus;
        JSONArray buttonGroups;
        String parseContext = "parseFeature";
        ResourceBundle resourceBundle = feature.getResourceBundle();
        String featureId = feature.getFeatureId();
        JSONObject featureJSON = feature.getJson();
        JSONArray toolbars = this.getJsonProperty(featureJSON, KEY_TOOLBAR, JSONArray.class, parseContext);
        if (toolbars != null) {
            this.processArray(toolbars, resourceBundle);
            List<GFToolBar> contributedToolbars = this.parseElementListInContext(toolbars, GFToolBar.class, featureId, parseContext + ":" + KEY_TOOLBAR);
            feature.setToolbars(contributedToolbars);
        }
        if ((buttonGroups = this.getJsonProperty(featureJSON, KEY_ITEM_GROUP, JSONArray.class, parseContext)) != null) {
            this.processArray(buttonGroups, resourceBundle);
            List<GFToolItemGroup> contributedButtonGroups = this.parseElementListInContext(buttonGroups, GFToolItemGroup.class, featureId, parseContext + ":" + KEY_ITEM_GROUP);
            feature.setToolItemGroups(contributedButtonGroups);
        }
        if ((contextMenus = this.getJsonProperty(featureJSON, KEY_CONTEXT_MENU, JSONArray.class, parseContext)) != null) {
            this.processArray(contextMenus, resourceBundle);
            List<GFToolItem> contributedToolItems = this.processMenus(feature, contextMenus, parseContext + ":" + KEY_CONTEXT_MENU);
            if (!contributedToolItems.isEmpty()) {
                for (GFToolItem contextMenu : contributedToolItems) {
                    contextMenu.markAsContextMenu(true);
                }
                feature.setContextMenus(contributedToolItems);
            }
        }
        if ((toolBarItems = this.getJsonProperty(featureJSON, KEY_ITEM, JSONArray.class, parseContext)) != null) {
            this.processArray(toolBarItems, resourceBundle);
            List<GFToolItem> contributedToolItems = this.processMenus(feature, toolBarItems, parseContext + ":" + KEY_ITEM);
            if (!contributedToolItems.isEmpty()) {
                feature.setToolItems(contributedToolItems);
            }
        }
        if ((contributedDefaultActions = this.getJsonProperty(featureJSON, KEY_DEFAULT_ACTIONS, JSONArray.class, parseContext)) != null) {
            this.processArray(contributedDefaultActions, resourceBundle);
            List<GFAction> defaultActions = this.parseElementList(contributedDefaultActions, GFAction.class, featureId, parseContext + ":" + KEY_DEFAULT_ACTIONS);
            feature.setDefaultActions(defaultActions);
        }
        if ((collectionContainers = this.getJsonProperty(featureJSON, KEY_COLLECTION_CONTAINERS, JSONArray.class, parseContext)) != null) {
            this.processArray(collectionContainers, resourceBundle);
            List<GFCollectionContainer> contributedCollectionContainers = this.parseElementListInContext(collectionContainers, GFCollectionContainer.class, featureId, parseContext + ":" + KEY_COLLECTION_CONTAINERS);
            feature.setCollectionContainers(contributedCollectionContainers);
        }
        if ((collectionItemsJson = this.getJsonProperty(featureJSON, KEY_COLLECTION_ITEMS, JSONArray.class, parseContext)) != null) {
            this.processArray(collectionItemsJson, resourceBundle);
            List<GFCollectionItem> contributedCollectionItems = this.parseElementList(collectionItemsJson, GFCollectionItem.class, featureId, parseContext + ":" + KEY_COLLECTION_ITEMS);
            this.storeCollectionItems(this.collectionItems, contributedCollectionItems);
        }
    }

    private void storeCollectionItems(List<GFCollectionItem> allItems, List<GFCollectionItem> newItems) {
        if (newItems != null && !newItems.isEmpty()) {
            for (GFCollectionItem newItem : newItems) {
                for (GFCollectionItem existingItem : allItems) {
                    if (!existingItem.getId().equals(newItem.getId())) continue;
                    try {
                        existingItem.merge(existingItem.properties, newItem.properties);
                        break;
                    }
                    catch (JSONException e) {
                        Exception ex = new Exception("Could not merge collection Item.", e);
                        this.logger.logException(ex);
                    }
                }
                allItems.add(newItem);
            }
        }
    }

    private void injectCollectionItems(List<GFFeature> features, List<GFCollectionItem> collectionItems) {
        if (features == null || features.isEmpty()) {
            return;
        }
        if (collectionItems.isEmpty()) {
            return;
        }
        for (GFFeature feature : features) {
            if (feature == null) continue;
            feature.addCollectionItems(collectionItems);
        }
    }

    private List<GFToolItem> processMenus(GFFeature feature, JSONArray toolBarItems, String parseContext) {
        String featureId = feature.getFeatureId();
        List<GFToolItem> contributedToolItems = this.parseElementListInContext(toolBarItems, GFToolItem.class, featureId, parseContext);
        ArrayList<GFToolItem> toRemove = new ArrayList<GFToolItem>();
        for (GFToolItem contributedToolItem : contributedToolItems) {
            if (contributedToolItem.isMenu() || contributedToolItem.isMenuContribution() || contributedToolItem.isMenuItem()) {
                List<GFToolMenuItem> contributedMenuItems = this.extractMenuItems(contributedToolItem, featureId, parseContext);
                feature.addToolMenuItems(contributedMenuItems);
            }
            if (!contributedToolItem.isTransient()) continue;
            toRemove.add(contributedToolItem);
        }
        contributedToolItems.removeAll(toRemove);
        return contributedToolItems;
    }

    private List<GFToolMenuItem> extractMenuItems(GFToolItem contributedToolItem, String featureId, String parseContext) {
        List<GFUIElement> elements;
        JSONObject contributedItemProperties = contributedToolItem.getProperties();
        JSONArray contributedItems = this.getJsonProperty(contributedItemProperties, "items", JSONArray.class, parseContext);
        if (contributedItems == null) {
            return null;
        }
        contributedItemProperties.remove((Object)"items");
        String containerId = null;
        if (contributedToolItem.isMenu()) {
            containerId = contributedToolItem.getId();
        } else if (contributedToolItem.isMenuContribution() || contributedToolItem.isMenuItem()) {
            containerId = contributedToolItem.getContainerId();
        }
        if (containerId == null) {
            return null;
        }
        Map<String, List<GFUIElement>> featureElements = this.elementsById.get(featureId);
        if (featureElements == null) {
            featureElements = new HashMap<String, List<GFUIElement>>();
            this.elementsById.put(featureId, featureElements);
        }
        if ((elements = featureElements.get(containerId)) == null) {
            elements = new ArrayList<GFUIElement>();
            featureElements.put(containerId, elements);
        }
        String menuController = this.getJsonProperty(contributedItemProperties, KEY_ITEM_CONTROLLER, String.class, parseContext);
        JSONObject menuControllerConfig = this.getJsonProperty(contributedItemProperties, KEY_ITEM_CONTROLLER_CONFIG, JSONObject.class, parseContext);
        List<GFToolMenuItem> contributedMenuItems = this.parseElementList(contributedItems, GFToolMenuItem.class, featureId, parseContext + ":" + "items");
        for (GFToolMenuItem contributedMenuItem : contributedMenuItems) {
            if (contributedToolItem.isMenuItem()) {
                JSONObject menuItemProps = contributedMenuItem.getProperties();
                String newFeatureId = featureId + '.' + contributedMenuItem.getId();
                try {
                    menuItemProps.put(KEY_FEATURE_ID, (Object)newFeatureId);
                }
                catch (JSONException e) {
                    Exception ex = new Exception("Feature Id could not be updated for menu item.", e);
                    this.logger.logException(ex);
                }
            }
            elements.add(contributedMenuItem);
            if (menuController == null) continue;
            contributedMenuItem.setController(menuController);
            contributedMenuItem.setControllerConfig(menuControllerConfig);
        }
        if (menuController != null) {
            contributedItemProperties.remove((Object)KEY_ITEM_CONTROLLER);
            contributedItemProperties.remove((Object)KEY_ITEM_CONTROLLER_CONFIG);
        }
        return contributedMenuItems;
    }

    private <T extends GFUIElement> List<T> parseElementListInContext(JSONArray json, Class<T> expectedType, String featureId, String parseContext) {
        Map<String, List<GFUIElement>> featureElements = this.elementsById.get(featureId);
        if (featureElements == null) {
            featureElements = new HashMap<String, List<GFUIElement>>();
            this.elementsById.put(featureId, featureElements);
        }
        List<T> result = this.parseElementList(json, expectedType, featureId, parseContext);
        for (GFUIElement element : result) {
            List<GFUIElement> elements;
            if (element.isTransient()) continue;
            String containerId = element.getContainerId();
            if (containerId == null && (containerId = this.itemContainerIds.get(element.getId())) == null) {
                containerId = TOP_CONTAINER_ID;
            }
            if ((elements = featureElements.get(containerId)) == null) {
                elements = new ArrayList<GFUIElement>();
                featureElements.put(containerId, elements);
            }
            elements.add(element);
            this.itemContainerIds.put(element.getId(), containerId);
        }
        return result;
    }

    private void processValue(JSONObject json, ResourceBundle resourceBundle) {
        for (Object key : json.keySet()) {
            String stringValue;
            String processedValue;
            Object value = json.get(key);
            if (value instanceof JSONObject) {
                this.processValue((JSONObject)value, resourceBundle);
                continue;
            }
            if (value instanceof JSONArray) {
                this.processArray((JSONArray)value, resourceBundle);
                continue;
            }
            if (!(value instanceof String) || (processedValue = this.processString(stringValue = value.toString(), resourceBundle)) == null) continue;
            json.put(key, (Object)processedValue);
        }
    }

    private void processArray(JSONArray json, ResourceBundle resourceBundle) {
        for (int i = 0; i < json.length(); ++i) {
            String processedValue;
            Object value = json.get(i);
            if (value instanceof JSONObject) {
                this.processValue((JSONObject)value, resourceBundle);
                continue;
            }
            if (value instanceof JSONArray) {
                this.processArray((JSONArray)value, resourceBundle);
                continue;
            }
            if (!(value instanceof String) || (processedValue = this.processString((String)value, resourceBundle)) == null) continue;
            try {
                json.put(i, (Object)processedValue);
                continue;
            }
            catch (JSONException e) {
                this.logger.logException((Exception)((Object)e));
            }
        }
    }

    private String processString(String value, ResourceBundle resourceBundle) {
        if (value.startsWith(THEME_INDICATOR)) {
            return this.getThemeValue(value.substring(THEME_INDICATOR.length()));
        }
        if (resourceBundle == null) {
            return null;
        }
        if (!value.startsWith(TRANSLATE_INDICATOR)) {
            return null;
        }
        if (value.startsWith(NO_TRANSLATE_INDICATOR)) {
            return null;
        }
        String translateKey = value.substring(TRANSLATE_INDICATOR.length());
        if (!resourceBundle.containsKey(translateKey)) {
            return null;
        }
        return resourceBundle.getString(translateKey);
    }

    private String getThemeValue(String key) {
        Theme theme = this.config.getTheme();
        String retVal = theme == null ? key : theme.getValue(key);
        return retVal;
    }

    private void sortByWeight(JSONObject json) {
        for (Object key : json.keySet()) {
            Object value = json.get(key);
            if (value instanceof JSONObject) {
                this.sortByWeight((JSONObject)value);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            this.sortByWeight((JSONArray)value);
        }
    }

    private void sortByWeight(JSONArray jsonArray) {
        boolean hasWeight = false;
        boolean allJSONObjects = true;
        for (Object element : jsonArray) {
            if (element instanceof JSONObject) {
                this.sortByWeight((JSONObject)element);
                hasWeight = hasWeight || ((JSONObject)element).containsKey((Object)KEY_WEIGHT);
                continue;
            }
            if (element instanceof JSONArray) {
                this.sortByWeight((JSONArray)element);
                allJSONObjects = false;
                continue;
            }
            allJSONObjects = false;
        }
        if (!hasWeight || !allJSONObjects) {
            return;
        }
        try {
            int i;
            ArrayList<JSONObject> tmp = new ArrayList<JSONObject>(jsonArray.length());
            for (i = 0; i < jsonArray.length(); ++i) {
                tmp.add(jsonArray.getJSONObject(i));
            }
            Collections.sort(tmp, new WeightComparator());
            jsonArray.clear();
            for (i = 0; i < tmp.size(); ++i) {
                JSONObject element = (JSONObject)tmp.get(i);
                if (element.containsKey((Object)KEY_WEIGHT)) {
                    element.remove((Object)KEY_WEIGHT);
                }
                jsonArray.add(tmp.get(i));
            }
        }
        catch (JSONException e) {
            this.logger.logException((Exception)((Object)e));
        }
    }

    private void processExtensionFeature(JSONObject feature) {
        this.injectContentViewAdaptorModule(feature);
        this.processExtensionMenuItems(feature);
    }

    private void registerExclusions(JSONObject featureJSON) {
        List<String> excludedItems;
        List<String> excludedFeatures = this.getJsonArray(featureJSON, KEY_EXCLUDED_FEATURES, String.class, KEY_EXCLUDED_FEATURES);
        if (excludedFeatures != null) {
            this.excludedSharedFeatures.addAll(excludedFeatures);
        }
        if ((excludedItems = this.getJsonArray(featureJSON, KEY_EXCLUDED_ITEMS, String.class, KEY_EXCLUDED_ITEMS)) != null) {
            this.excludedSharedItems.addAll(excludedItems);
        }
    }

    private void injectContentViewAdaptorModule(JSONObject feature) {
        JSONObject content = this.getJsonProperty(feature, "content", JSONObject.class, "content");
        if (content != null) {
            String module = this.getJsonProperty(content, KEY_MODULE, String.class, KEY_MODULE);
            String type = this.getJsonProperty(content, KEY_TYPE, String.class, KEY_TYPE);
            if (module == null && type != null) {
                try {
                    content.put(KEY_MODULE, (Object)CONTENTVIEW_V2_ADAPTOR_MODULE);
                }
                catch (JSONException e) {
                    Exception ex = new Exception("Unable to set v2 contentView adaptor for extension", e);
                    this.logger.logException(ex);
                }
            } else {
                feature.remove((Object)"content");
            }
        }
    }

    private void processExtensionMenuItems(JSONObject feature) {
        for (int i = 0; i < MENUS.length; ++i) {
            JSONArray genericItemSpec = this.getJsonProperty(feature, MENUS[i], JSONArray.class, MENUS[i]);
            if (genericItemSpec == null) continue;
            for (int j = 0; j < genericItemSpec.length(); ++j) {
                try {
                    JSONObject spec = genericItemSpec.getJSONObject(j);
                    String type = this.getJsonProperty(spec, KEY_TYPE, String.class, KEY_TYPE);
                    if (type == null || type.compareToIgnoreCase(TOOLITEM_MENU_ITEM) != 0) continue;
                    this.convertToMenuContributionSpec(spec);
                    continue;
                }
                catch (JSONException e) {
                    Exception ex = new Exception("Invalid spec uploaded for context menu item.", e);
                    this.logger.logException(ex);
                }
            }
        }
    }

    private void convertToMenuContributionSpec(JSONObject spec) {
        try {
            JSONObject item = new JSONObject();
            for (int i = 0; i < keysToMove.length; ++i) {
                Object value = this.getJsonProperty(spec, keysToMove[i], Object.class, keysToMove[i]);
                if (keysToMove[i].compareToIgnoreCase("id") != 0) {
                    spec.remove((Object)keysToMove[i]);
                }
                if (value == null) continue;
                item.put(keysToMove[i], value);
            }
            JSONArray items = new JSONArray();
            items.add((Object)item);
            spec.put("items", (Collection)items);
        }
        catch (JSONException e) {
            Exception ex = new Exception("Unable to convert Menu Item to Menu Contribution", e);
            this.logger.logException(ex);
        }
    }

    private void buildLensableFeatureMap(List<GFFeature> features, Map<String, Boolean> featureIsLensableById) {
        for (GFFeature feature : features) {
            String featureId = feature.getFeatureId();
            if (featureIsLensableById.containsKey(featureId) && featureIsLensableById.get(featureId) != null) continue;
            featureIsLensableById.put(featureId, feature.getIsLensable());
        }
    }

    private void parseCssStyles(JSONObject featureJSON, GFFeature feature, String parseContext) {
        JSONArray cssStylesArray = this.getJsonProperty(featureJSON, KEY_CSS_STYLE, JSONArray.class, parseContext);
        List<String> cssStyles = this.convertJsonArrayToList(cssStylesArray, parseContext + ":" + KEY_CSS_STYLE);
        if (cssStyles != null) {
            feature.setCssStyles(cssStyles);
            featureJSON.remove((Object)KEY_CSS_STYLE);
        }
    }

    private void parseSvgImages(JSONObject featureJSON, GFFeature feature, String parseContext) {
        JSONArray svgImagesArray = this.getJsonProperty(featureJSON, KEY_SVG_IMAGES, JSONArray.class, parseContext);
        List<String> svgImages = this.convertJsonArrayToList(svgImagesArray, parseContext + ":" + KEY_SVG_IMAGES);
        if (svgImages != null) {
            feature.setSvgImages(svgImages);
            featureJSON.remove((Object)KEY_SVG_IMAGES);
        }
    }

    private void parseActionsFromExtension(JSONObject featureJSON, GFFeature feature, String parseContext) {
        try {
            JSONArray actionsArray = this.getJsonProperty(featureJSON, KEY_DEFAULT_ACTIONS, JSONArray.class, parseContext);
            if (actionsArray != null && !actionsArray.isEmpty()) {
                ArrayList<GFAction> parsedActions = new ArrayList<GFAction>();
                String featureId = feature.getFeatureId();
                for (int i = 0; i < actionsArray.length(); ++i) {
                    JSONObject action = actionsArray.getJSONObject(i);
                    String actionId = action.getString("id");
                    JSONObject actionItems = new JSONObject();
                    actionItems.put("items", (Collection)action.getJSONArray("items"));
                    GFAction defaultAction = new GFAction();
                    defaultAction.initialize(actionId, featureId, actionItems, null);
                    parsedActions.add(defaultAction);
                }
                feature.setDefaultActions(parsedActions);
            }
        }
        catch (JSONException e) {
            Exception ex = new Exception("Unable to parse actions from extension", e);
            this.logger.logException(ex);
        }
    }

    private List<String> convertJsonArrayToList(JSONArray array, String parseContext) {
        ArrayList<String> list = null;
        if (array != null) {
            list = new ArrayList<String>(array.length());
            for (Object value : array) {
                if (value instanceof String) {
                    String str = (String)value;
                    if (str.isEmpty()) continue;
                    list.add(str);
                    continue;
                }
                this.logger.logError("Expecting String, but got: " + value.toString(), parseContext);
            }
        }
        return list;
    }

    private class WeightComparator
    implements Comparator<JSONObject> {
        private WeightComparator() {
        }

        private int compareIds(JSONObject jsonA, JSONObject jsonB) {
            int result = 0;
            try {
                String idA = jsonA.getString("id");
                String idB = jsonB.getString("id");
                result = idA.compareTo(idB);
            }
            catch (JSONException jsone) {
                GFModel.this.logger.logInfoException("comparing elements with no id", jsone);
            }
            return result;
        }

        @Override
        public int compare(JSONObject jsonA, JSONObject jsonB) {
            try {
                boolean hasWeightA = jsonA.containsKey((Object)GFModel.KEY_WEIGHT);
                boolean hasWeightB = jsonB.containsKey((Object)GFModel.KEY_WEIGHT);
                if (hasWeightA && hasWeightB) {
                    int weightB;
                    int weightA = jsonA.getInt(GFModel.KEY_WEIGHT);
                    if (weightA < (weightB = jsonB.getInt(GFModel.KEY_WEIGHT))) {
                        return 1;
                    }
                    if (weightA > weightB) {
                        return -1;
                    }
                } else {
                    if (hasWeightA) {
                        return -1;
                    }
                    if (hasWeightB) {
                        return 1;
                    }
                }
                return this.compareIds(jsonA, jsonB);
            }
            catch (JSONException e) {
                GFModel.this.logger.logException((Exception)((Object)e));
                return 0;
            }
        }
    }
}

