/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.model;

import com.ibm.ba.glass.model.GFUIElement;
import com.ibm.ba.glass.utils.Logger;
import org.apache.commons.json.JSONObject;

public class GFToolItem
extends GFUIElement {
    private static final String JSON_SECTION_KEY = "toolItems";
    private static final String JSON_CONTEXT_SECTION_KEY = "contextMenus";
    private static final String KEY_ITEM_TYPE = "type";
    private static final String KEY_MENU = "Menu";
    private static final String KEY_MENU_CONTRIBUTION = "MenuContribution";
    private static final String KEY_MENU_ITEM = "MenuItem";
    private boolean isMenu;
    private boolean isContextMenu;
    private boolean isMenuContribution;
    private boolean isMenuItem;

    @Override
    protected String getSectionKey() {
        return this.isContextMenu() ? JSON_CONTEXT_SECTION_KEY : JSON_SECTION_KEY;
    }

    @Override
    public void initialize(String id, String featureId, JSONObject contents, Logger useLogger) {
        super.initialize(id, featureId, contents, useLogger);
        String itemType = this.getJsonProperty(contents, KEY_ITEM_TYPE, String.class, featureId);
        this.isMenu = KEY_MENU.equals(itemType);
        this.isMenuContribution = KEY_MENU_CONTRIBUTION.equals(itemType);
        this.isMenuItem = KEY_MENU_ITEM.equals(itemType);
    }

    public boolean isMenu() {
        return this.isMenu;
    }

    public boolean isContextMenu() {
        return this.isContextMenu;
    }

    public boolean isMenuContribution() {
        return this.isMenuContribution;
    }

    public boolean isMenuItem() {
        return this.isMenuItem;
    }

    @Override
    public boolean isTransient() {
        return this.isMenuContribution() || this.isMenuItem();
    }

    public void markAsContextMenu(boolean isContextMenu) {
        this.isContextMenu = isContextMenu;
    }
}

