/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.model;

import com.ibm.ba.glass.model.GFUIElement;
import com.ibm.ba.glass.utils.Logger;
import java.util.Map;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class GFToolMenuItem
extends GFUIElement {
    private static final String JSON_SECTION_KEY = "items";
    private static final String JSON_FEATURE_KEY = "featureId";
    private static final String JSON_CONTROLLERS_KEY = "actionControllers";
    private static final String JSON_CONTROLLER_CONFIG_KEY = "controllerConfig";
    private String controller;
    private JSONObject controllerConfig;

    @Override
    protected String getSectionKey() {
        return JSON_SECTION_KEY;
    }

    public String getController() {
        return this.controller;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    public JSONObject getControllerConfig() {
        return this.controllerConfig;
    }

    public void setControllerConfig(JSONObject controllerConfig) {
        this.controllerConfig = controllerConfig;
    }

    @Override
    public void initialize(String id, String featureId, JSONObject contents, Logger useLogger) {
        super.initialize(id, featureId, contents, useLogger);
        try {
            this.properties.put(JSON_FEATURE_KEY, (Object)featureId);
        }
        catch (JSONException e) {
            useLogger.logException((Exception)((Object)e));
        }
    }

    private JSONObject getFromJSON(String key, JSONObject json) throws JSONException {
        JSONObject result;
        if (json.containsKey((Object)key)) {
            result = (JSONObject)json.get(key);
        } else {
            result = new JSONObject();
            json.put(key, (Map)result);
        }
        return result;
    }

    @Override
    public JSONObject write(JSONObject json) throws JSONException {
        JSONObject result = super.write(json);
        if (this.controller != null) {
            String featureId = this.properties.getString(JSON_FEATURE_KEY);
            JSONObject controllers = this.getFromJSON(JSON_CONTROLLERS_KEY, json);
            controllers.put(featureId, (Object)this.controller);
            if (this.controllerConfig != null) {
                JSONObject controllerConfigs = this.getFromJSON(JSON_CONTROLLER_CONFIG_KEY, json);
                controllerConfigs.put(featureId, (Map)this.controllerConfig);
            }
        }
        return result;
    }
}

