/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.model;

import com.ibm.ba.glass.model.JSONBase;
import com.ibm.ba.glass.utils.Logger;
import java.util.Collection;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public abstract class GFUIElement
extends JSONBase {
    private static final String CONTAINER_ID = "containerId";
    public static final String ENV_KEY = "environment";
    public static final String ENV_CAPABILITIES_KEY = "capabilities";
    public static final String ENV_ROLES_KEY = "roles";
    public static final String ENV_DEVICES_KEY = "deviceTypes";
    public static final String ENV_MODES_KEY = "installModes";
    protected String id;
    protected String containerId;
    protected Boolean isLensable;
    protected JSONObject properties;

    protected abstract String getSectionKey();

    public void initialize(String id, String featureId, JSONObject contents, Logger useLogger) {
        if (id != null) {
            this.id = id.indexOf(46) < 0 ? featureId + '.' + id : id;
        }
        this.properties = contents;
        this.logger = useLogger;
        String propertyContainerId = this.getJsonProperty(this.properties, CONTAINER_ID, String.class, CONTAINER_ID);
        if (propertyContainerId != null) {
            this.properties.remove((Object)CONTAINER_ID);
            String string = this.containerId = propertyContainerId.indexOf(46) < 0 ? featureId + '.' + propertyContainerId : propertyContainerId;
        }
        if (this.properties.containsKey((Object)"lensable")) {
            this.isLensable = this.getJsonProperty(this.properties, "lensable", Boolean.class, "lensable");
            this.properties.remove((Object)"lensable");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public JSONObject getProperties() {
        return this.properties;
    }

    public void setIsLensable(Boolean value) {
        if (value != null) {
            this.isLensable = value;
        }
    }

    public Boolean getIsLensable() {
        return this.isLensable;
    }

    public JSONObject write(JSONObject json) throws JSONException {
        JSONArray section;
        String sectionKey = this.getSectionKey();
        if (json.containsKey((Object)sectionKey)) {
            section = (JSONArray)json.get(sectionKey);
        } else {
            section = new JSONArray();
            json.put(sectionKey, (Collection)section);
        }
        JSONObject elementJson = (JSONObject)this.properties.clone();
        elementJson.put("id", (Object)this.id);
        if (this.isLensable != null) {
            elementJson.put("lensable", (Object)this.isLensable);
        }
        boolean merge = false;
        for (int i = 0; i < section.length(); ++i) {
            JSONObject obj = section.getJSONObject(i);
            if (!this.id.equals(obj.get("id"))) continue;
            merge = true;
            this.merge(obj, elementJson);
            break;
        }
        if (!merge) {
            section.add((Object)elementJson);
        }
        return elementJson;
    }

    public boolean isTransient() {
        return false;
    }
}

