/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.model;

import com.ibm.ba.glass.model.GFUIElement;
import com.ibm.ba.glass.utils.Logger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JSONBase {
    protected static final String KEY_ID = "id";
    protected static final String COMMON_DIR = "common";
    protected static final String PERSPECTIVE_COMMON = "common";
    protected Logger logger = new Logger();

    public <T extends GFUIElement> List<T> parseElementList(JSONArray json, Class<T> expectedType, String featureId, String parseContext) {
        ArrayList<GFUIElement> result = new ArrayList<GFUIElement>();
        for (Object object : json) {
            GFUIElement element;
            if (!(object instanceof JSONObject)) {
                this.logger.logError("Expecting JSONObject, but got: " + object.toString(), parseContext);
                continue;
            }
            JSONObject objectJSON = (JSONObject)object;
            String id = this.getJsonProperty(objectJSON, KEY_ID, String.class, parseContext);
            if (id == null) continue;
            objectJSON.remove((Object)KEY_ID);
            try {
                element = (GFUIElement)expectedType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Exception ex = new Exception("Internal error: " + parseContext, e);
                this.logger.logException(ex);
                continue;
            }
            element.initialize(id, featureId, objectJSON, this.logger);
            result.add(element);
        }
        return result;
    }

    public <T> T getJsonProperty(JSONObject json, String propertyName, Class<T> expectedType, String parserContents) {
        if (json == null) {
            return null;
        }
        if (!json.containsKey((Object)propertyName)) {
            return null;
        }
        Object object = null;
        try {
            object = json.get(propertyName);
        }
        catch (JSONException e) {
            Exception ex = new Exception(parserContents, e);
            this.logger.logException(ex);
            return null;
        }
        if (object == null) {
            return null;
        }
        try {
            return expectedType.cast(object);
        }
        catch (ClassCastException e) {
            Exception ex = new Exception("Expecting " + expectedType + ", but got: " + object.toString() + ". [" + parserContents + "]", e);
            this.logger.logException(ex);
            return null;
        }
    }

    public <T> List<T> getJsonArray(JSONObject json, String propertyName, Class<T> expectedType, String parserContents) {
        JSONArray jsonArray = this.getJsonProperty(json, propertyName, JSONArray.class, parserContents);
        if (jsonArray == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value = jsonArray.get(i);
            try {
                result.add(expectedType.cast(value));
                continue;
            }
            catch (ClassCastException e) {
                Exception ex = new Exception("Expecting " + expectedType + ", but got: " + value.toString() + ". [" + parserContents + "]", e);
                this.logger.logException(ex);
            }
        }
        return result;
    }

    public void merge(JSONObject src, JSONObject merge) throws JSONException {
        for (Object key : merge.keySet()) {
            Object existingValue = src.get(key);
            Object mergeValue = merge.get(key);
            if (existingValue != null) {
                if (!existingValue.getClass().isAssignableFrom(mergeValue.getClass())) {
                    this.logger.logError(String.format("Unable to merge json key: %s. The existing and merge value have different object types", key), mergeValue.getClass().getName());
                    continue;
                }
                if (mergeValue instanceof JSONObject) {
                    this.merge((JSONObject)existingValue, (JSONObject)mergeValue);
                    continue;
                }
                src.put(key, mergeValue);
                continue;
            }
            src.put(key, mergeValue);
        }
    }
}

