/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.model;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.defaults.DefaultTheme;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.loader.ExtensionLoader;
import com.ibm.ba.glass.loader.PerspectiveLoader;
import com.ibm.ba.glass.model.GFModel;
import com.ibm.ba.glass.model.GFModelConfig;
import com.ibm.ba.glass.resource.Theme;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.ba.glass.utils.JsonObjectUtils;
import com.ibm.bi.json.JsonObject;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerspectiveProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerspectiveProcessor.class);
    private static final String DEFAULT_LANGUAGE = "en";
    @Inject
    @Managed
    private ExtensionLoader extLoader;
    @Inject
    @Managed
    private PerspectiveLoader perspectiveLoader;
    @Inject
    private DefaultTheme defaultTheme;

    public JsonObject generateRawDefinition(String perspectiveId) throws ResourceNotFoundException {
        GFModelConfig modelConfig = new GFModelConfig(perspectiveId, Locale.forLanguageTag(DEFAULT_LANGUAGE), this.createTheme(), this.getCurrentExtensions(), true);
        GFModel model = this.createModel();
        JSONObject definition = null;
        try {
            this.perspectiveLoader.load(modelConfig);
            definition = model.getCombinedJSON(modelConfig, this.perspectiveLoader);
        }
        catch (ResourceNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        return JsonObjectUtils.convertToJsonObject(definition);
    }

    private JSONObject getCurrentExtensions() {
        try {
            return this.extLoader.getMasterExtension();
        }
        catch (ESException ioe) {
            LOGGER.error("Unable to get current extension spec. Defaulting to factoryMode.");
            return new JSONObject();
        }
    }

    protected GFModel createModel() {
        return new GFModel();
    }

    protected Theme createTheme() {
        return new Theme(this.defaultTheme.getSpec());
    }
}

