/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.parser;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigParser {
    private static final String KEY_CONFIG = "config";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigParser.class);

    public static JSONArray readArray(JSONObject spec, String propertyName) {
        JSONObject config = spec.optJSONObject(KEY_CONFIG);
        if (config != null) {
            try {
                return config.optJSONArray(propertyName);
            }
            catch (JSONException error) {
                LOGGER.error("Error parsing contribution JSON specification.", (Throwable)error);
            }
        }
        return null;
    }

    public static JSONObject readObject(JSONObject spec, String propertyName) {
        JSONObject config = spec.optJSONObject(KEY_CONFIG);
        return config != null ? config.optJSONObject(propertyName) : null;
    }

    public static void write(JSONObject spec, String propertyName, JSONArray propertyValue) {
        if (!propertyValue.isEmpty()) {
            JSONObject configObject = spec.optJSONObject(KEY_CONFIG);
            try {
                if (configObject == null) {
                    spec.put(KEY_CONFIG, (Map)new JSONObject().put(propertyName, (Collection)propertyValue));
                } else {
                    configObject.put(propertyName, (Collection)propertyValue);
                }
            }
            catch (JSONException error) {
                LOGGER.error("Error creating JSON output.", (Throwable)error);
            }
        }
    }
}

