/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.parser;

import com.ibm.ba.glass.parser.ConfigParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class GenericWeightedParser {
    private final String configPropertyKey;
    private List<JSONObject> pathAndWeights = new ArrayList<JSONObject>();

    public GenericWeightedParser(String configPropertyKey) {
        this.configPropertyKey = configPropertyKey;
    }

    public void read(JSONObject spec) {
        JSONArray pathAndWeights = ConfigParser.readArray(spec, this.configPropertyKey);
        if (pathAndWeights != null) {
            this.pathAndWeights.addAll((Collection<JSONObject>)pathAndWeights);
        }
    }

    public void write(JSONObject spec) throws JSONException {
        this.prioritizeLoadOrder();
        JSONArray jsonArrayOfJustPaths = this.removeWeights();
        ConfigParser.write(spec, this.configPropertyKey, jsonArrayOfJustPaths);
    }

    private void prioritizeLoadOrder() throws JSONException {
        this.pathAndWeights.sort(new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                int secondObjectWeight;
                int firstObjectWeight = o1.optInt("weight", Integer.MAX_VALUE);
                if (firstObjectWeight == (secondObjectWeight = o2.optInt("weight", Integer.MAX_VALUE))) {
                    return 0;
                }
                return firstObjectWeight < secondObjectWeight ? -1 : 1;
            }
        });
    }

    private JSONArray removeWeights() throws JSONException {
        JSONArray jsonArrayOfJustPaths = new JSONArray();
        for (JSONObject curPathWeightObject : this.pathAndWeights) {
            jsonArrayOfJustPaths.add((Object)curPathWeightObject.getString("path"));
        }
        return jsonArrayOfJustPaths;
    }
}

