/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.parser;

import com.ibm.ba.glass.parser.Parser;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parsers {
    private static final Logger LOGGER = LoggerFactory.getLogger(Parsers.class);
    private List<Parser> listOfParsers = Arrays.asList(new Parser[0]);

    public Parsers(List<Parser> listOfParsers) {
        this.listOfParsers = listOfParsers;
    }

    public void readAll(JSONObject spec) {
        for (Parser parser : this.listOfParsers) {
            parser.read(spec);
        }
    }

    public JSONObject writeAll() {
        JSONObject processedData = new JSONObject();
        this.writeAll(processedData);
        return processedData;
    }

    public void writeAll(JSONObject spec) {
        if (spec != null) {
            for (Parser parser : this.listOfParsers) {
                this.attemptWrite(parser, spec);
            }
        }
    }

    private void attemptWrite(Parser parser, JSONObject spec) {
        try {
            parser.write(spec);
        }
        catch (JSONException error) {
            LOGGER.error("Unable to write parser data to spec", (Throwable)error);
        }
    }
}

