/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.parser;

import com.ibm.ba.glass.parser.Parser;
import java.util.Map;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesParser
implements Parser {
    public static final String KEY_SERVICES = "services";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesParser.class);
    private JSONObject servicesJson = new JSONObject();

    @Override
    public void read(JSONObject spec) {
        JSONObject services = spec.optJSONObject(KEY_SERVICES);
        if (services != null) {
            for (String key : JSONObject.getNames((JSONObject)services)) {
                try {
                    this.servicesJson.put(key, services.get(key));
                }
                catch (JSONException e) {
                    LOGGER.error("Failed to merge service.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void write(JSONObject json) throws JSONException {
        if (!this.servicesJson.isEmpty()) {
            json.put(KEY_SERVICES, (Map)this.servicesJson);
        }
    }
}

