/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.resource;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.resource.JaxrsFileResource;
import com.ibm.ba.glass.resource.RootFolder;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.ba.glass.utils.ExtensionUtils;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.inject.Inject;
import javax.ws.rs.core.PathSegment;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Managed
public class BaseJaxrsFileResource
implements JaxrsFileResource {
    private String customizationFolder;
    private String customizationName;
    private String relativePath;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseJaxrsFileResource.class);
    @Inject
    @Managed
    private RootFolder rootFolder;

    public void initialize(String customizationFolder, String customizationName, String pathInZip) {
        this.customizationFolder = customizationFolder;
        this.customizationName = customizationName;
        this.relativePath = this.customizationFolder + File.separator + this.customizationName + File.separator + pathInZip;
    }

    public void initialize(String customizationFolder, String customizationName, List<PathSegment> path) {
        StringBuilder relativePathBuilder = new StringBuilder();
        relativePathBuilder.append(customizationFolder + File.separator + customizationName);
        for (PathSegment pathSegment : path) {
            relativePathBuilder.append(File.separator + pathSegment.getPath());
        }
        this.customizationFolder = customizationFolder;
        this.customizationName = customizationName;
        this.relativePath = relativePathBuilder.toString();
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    protected String getFilePath() {
        return this.getRootFolder() + File.separator + this.getRelativePath();
    }

    protected File getFile() {
        return new File(this.getFilePath());
    }

    protected Path getPath() {
        return this.getFile().toPath();
    }

    public void write(OutputStream out) throws IOException {
        Lock lock = this.getLock().readLock();
        lock.lock();
        try {
            InputStream is = this.getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)out);
            is.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new ResourceNotFoundException(fnfe);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public JsonObject getResourceAsJson() throws ESException {
        JsonObject jsonObject = null;
        FileReader reader = null;
        Lock lock = this.getLock().readLock();
        lock.lock();
        try {
            reader = this.getFileReader();
            JsonParser parser = this.getJsonParser();
            jsonObject = (JsonObject)parser.parse((Reader)reader);
        }
        catch (IOException ioe) {
            throw new ESException("Failed to parse json file", ioe);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            lock.unlock();
        }
        return jsonObject;
    }

    protected FileReader getFileReader() throws FileNotFoundException {
        return new FileReader(this.getFile());
    }

    protected JsonParser getJsonParser() {
        return new JsonParser();
    }

    protected String getRootFolder() {
        try {
            return this.rootFolder.getRootFolderPath();
        }
        catch (ESException error) {
            LOGGER.error("Unable to get Root Folder Path.", (Throwable)error);
            return new File(".").getAbsolutePath();
        }
    }

    protected InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.getFile());
    }

    protected ReadWriteLock getLock() {
        return ExtensionUtils.getInstance().getLock();
    }

    public String getMediaType() {
        String mediaType = null;
        try {
            mediaType = Files.probeContentType(this.getPath());
        }
        catch (IOException ioe) {
            LOGGER.error("Error getting media type of file", (Throwable)ioe);
        }
        return mediaType;
    }
}

