/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.resource;

import com.ibm.ba.glass.parser.Parser;
import com.ibm.ba.glass.parser.Parsers;
import com.ibm.ba.glass.parser.RequireJSParser;
import com.ibm.ba.glass.parser.ScriptParser;
import com.ibm.ba.glass.parser.ServicesParser;
import com.ibm.ba.glass.parser.StyleParser;
import com.ibm.ba.glass.resource.Specification;
import com.ibm.ba.glass.utils.JsonObjectUtils;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionSpecification
implements Specification {
    public static final String PROPERTY_CAPABILITIES = "capabilities";
    public static final String PROPERTY_CONTENT = "content";
    public static final String PROPERTY_EXTENSIONS = "extensions";
    public static final String PROPERTY_FEATURES = "features";
    public static final String PROPERTY_PERSPECTIVE = "perspective";
    public static final String PROPERTY_INHERITS = "inherits";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_LENSABLE = "lensable";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_SCHEMA_VERSION = "schemaVersion";
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_TOOL_ITEMS = "toolItems";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_EXCLUDE_COMMON = "excludeCommon";
    public static final String PROPERTY_SERVICES = "services";
    public static final String PROPERTY_CONFIG = "config";
    public static final String ICONS_PATH_PREFIX = "v1" + File.separator + "ext";
    private static final List<String> whiteListedRequiredProperties = Arrays.asList("perspective", "label", "name");
    private static final List<String> whiteListedOptionalProperties = Arrays.asList("services", "inherits", "type", "excludeCommon", "config");
    private static final String SUPPORTED_ICON_TYPES = ".+?(\\.svg|\\.jpg|\\.jpeg|\\.png)";
    private static final int NOT_FOUND = -1;
    private int numOfExtensions = -1;
    private JsonArray extensions = new JsonArray();
    private String name = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionSpecification.class);

    public ExtensionSpecification() {
        this.numOfExtensions = this.extensions.size();
    }

    public ExtensionSpecification(JsonObject specification, String name) {
        this.extensions.addAll((Collection)((JsonArray)specification.get(PROPERTY_EXTENSIONS)));
        String nameInSpec = specification.getString(PROPERTY_NAME);
        this.name = name == null ? nameInSpec : name;
        this.numOfExtensions = this.extensions.size();
    }

    public int getSize() {
        return this.numOfExtensions;
    }

    @Override
    public JsonObject getJsonSpec() {
        JsonObject obj = new JsonObject();
        obj.put(PROPERTY_EXTENSIONS, (Object)this.extensions);
        return obj;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JsonObject getExtension(int index) {
        if (index >= this.numOfExtensions) {
            LOGGER.error("Extensions index out of bounds");
            return null;
        }
        return this.extensions.getObject(index);
    }

    public JsonArray getFeatures(int extensionIndex) {
        JsonObject ext = this.getExtension(extensionIndex);
        if (ext == null || !ext.containsKey((Object)PROPERTY_FEATURES)) {
            return new JsonArray();
        }
        return (JsonArray)ext.get(PROPERTY_FEATURES);
    }

    public String getPerspective(int extensionIndex) {
        JsonObject ext = this.getExtension(extensionIndex);
        if (ext == null) {
            return null;
        }
        return ext.getString(PROPERTY_PERSPECTIVE);
    }

    public boolean merge(ExtensionSpecification srcSpec) {
        boolean modified = false;
        for (int i = 0; i < srcSpec.getSize(); ++i) {
            String perspectiveName;
            JsonObject rawExtension = srcSpec.getExtension(i);
            if (rawExtension.getString(PROPERTY_NAME) == null && srcSpec.getName() != null) {
                rawExtension.set(PROPERTY_NAME, (Object)srcSpec.getName());
            }
            if ((perspectiveName = rawExtension.getString(PROPERTY_PERSPECTIVE)) == null) continue;
            if (!this.isPerspectiveExtended(perspectiveName)) {
                this.addExtensionForPerspective(rawExtension);
            } else {
                this.updateExtensionForPerspective(perspectiveName, rawExtension);
                modified = true;
            }
            int extIndex = this.getPerspectiveIndex(perspectiveName);
            for (Object objFeature : srcSpec.getFeatures(i)) {
                JsonObject feature = this.processFeature(srcSpec.getName(), (JsonObject)objFeature);
                int featureIndex = this.existFeature(extIndex, feature.getString(PROPERTY_ID));
                if (featureIndex == -1) {
                    this.getFeatures(extIndex).add((Object)feature);
                } else {
                    LOGGER.warn("Overwriting feature " + feature.getString(PROPERTY_ID) + " in " + perspectiveName);
                    this.getFeatures(extIndex).set(featureIndex, (Object)feature);
                }
                modified = true;
            }
        }
        return modified;
    }

    private boolean isPerspectiveExtended(String perspectiveName) {
        return this.getPerspectiveIndex(perspectiveName) != -1;
    }

    private void addExtensionForPerspective(JsonObject rawExtension) {
        JsonObject processedExtension = this.createProcessedExtensionJsonObject(rawExtension);
        this.extensions.add((Object)processedExtension);
        ++this.numOfExtensions;
    }

    private JsonObject createProcessedExtensionJsonObject(JsonObject rawExtension) {
        JsonObject processedExtension = new JsonObject();
        this.putDefaultValues(processedExtension);
        this.putRequiredValues(processedExtension, rawExtension);
        this.putOptionalValues(processedExtension, rawExtension);
        return processedExtension;
    }

    private void putDefaultValues(JsonObject processedExtension) {
        processedExtension.put(PROPERTY_FEATURES, (Object)new JsonArray());
    }

    private void putRequiredValues(JsonObject processedExtension, JsonObject rawExtension) {
        for (String key : whiteListedRequiredProperties) {
            processedExtension.put(key, rawExtension.get(key));
        }
    }

    private void putOptionalValues(JsonObject processedExtension, JsonObject rawExtension) {
        for (String key : whiteListedOptionalProperties) {
            Object value = rawExtension.get(key);
            this.putIfNotNull(processedExtension, key, value);
        }
    }

    private void putIfNotNull(JsonObject object, String key, Object value) {
        if (value != null) {
            object.put(key, value);
        }
    }

    private void updateExtensionForPerspective(String perspectiveName, JsonObject rawExtension) {
        List<Parser> listOfParsers = Arrays.asList(new ServicesParser(), new RequireJSParser(), new StyleParser(), new ScriptParser());
        Parsers parsers = new Parsers(listOfParsers);
        JsonObject extension = this.getPerspectiveExtension(perspectiveName);
        this.readData(parsers, extension);
        this.readData(parsers, rawExtension);
        this.writeData(parsers, extension);
    }

    private void readData(Parsers parsers, JsonObject extension) {
        JSONObject processedExtension = JsonObjectUtils.convertToJSONObject(extension);
        parsers.readAll(processedExtension);
    }

    private void writeData(Parsers parsers, JsonObject extension) {
        JSONObject processedData = parsers.writeAll();
        for (Object key : processedData.keySet()) {
            extension.put((String)key, processedData.get(key));
        }
    }

    private JsonObject getPerspectiveExtension(String perspectiveName) {
        int indexOfExtension = this.getPerspectiveIndex(perspectiveName);
        return this.getExtension(indexOfExtension);
    }

    protected int getPerspectiveIndex(String perspectiveName) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!perspectiveName.equals(this.getPerspective(i))) continue;
            return i;
        }
        return -1;
    }

    protected JsonObject processFeature(String specName, JsonObject feature) {
        if (feature.containsKey((Object)PROPERTY_TOOL_ITEMS)) {
            for (Object objToolItem : (JsonArray)feature.get(PROPERTY_TOOL_ITEMS)) {
                JsonObject toolItem = (JsonObject)objToolItem;
                String icon = toolItem.getString(PROPERTY_ICON);
                if (!this.shouldPrependIconsPath(icon)) continue;
                toolItem.put(PROPERTY_ICON, (Object)this.prependIconsPath(specName, icon));
            }
        }
        return feature;
    }

    private boolean shouldPrependIconsPath(String icon) {
        return icon != null && Pattern.matches(SUPPORTED_ICON_TYPES, icon) && !icon.startsWith(ICONS_PATH_PREFIX);
    }

    protected String prependIconsPath(String specName, String value) {
        StringBuilder sb = new StringBuilder().append(ICONS_PATH_PREFIX).append("/").append(specName).append("/").append(value);
        return sb.toString();
    }

    protected int existFeature(int extIndex, String id) {
        JsonArray features = this.getFeatures(extIndex);
        for (int i = 0; i < features.size(); ++i) {
            if (!id.equals(features.getObject(i).getString(PROPERTY_ID))) continue;
            return i;
        }
        return -1;
    }
}

