/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.resource;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.ibm.ba.glass.resource.Theme;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.bi.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Palette {
    private static final String PALETTE_TEMPLATE = "palette.template.css";
    private static final Logger logger = LoggerFactory.getLogger(Theme.class);
    private JsonObject themeJsonSpec;
    private static MustacheFactory mf = null;
    private String paletteTemplatePath = "palette.template.css";

    public void initialize(JsonObject spec, String templatePath) throws ESException {
        this.initialize(spec);
        this.paletteTemplatePath = templatePath;
    }

    public void initialize(JsonObject spec) throws ESException {
        this.themeJsonSpec = spec;
        if (spec != null) {
            JsonObject colors = spec.getObject("colors");
            if (colors == null) {
                throw new ESException("Specification is missing color information.");
            }
            Set keys = colors.keySet();
            if (keys.isEmpty()) {
                throw new ESException("Specification is missing color information.");
            }
        }
    }

    private synchronized String getTemplateFile() throws ESException {
        InputStream stream = null;
        String template = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(this.paletteTemplatePath);
            template = IOUtils.toString((InputStream)stream);
            stream.close();
        }
        catch (IOException e) {
            try {
                throw new ESException("Failed to read css template file: ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return template;
    }

    private static MustacheFactory getMustacheFactory() {
        if (mf == null) {
            mf = new DefaultMustacheFactory();
        }
        return mf;
    }

    public String generateCSS() throws ESException {
        String template = this.getTemplateFile();
        return Palette.generateCSS(template, this.themeJsonSpec);
    }

    public static String generateCSS(String template, JsonObject spec) {
        String css = null;
        if (template == null || spec == null) {
            logger.debug("Empty template or json spec.");
        } else {
            try {
                MustacheFactory mf = Palette.getMustacheFactory();
                Mustache mustache = mf.compile((Reader)new StringReader(template), "palette");
                StringWriter sw = new StringWriter();
                mustache.execute((Writer)sw, (Object)spec).close();
                css = sw.toString();
                sw.close();
            }
            catch (IOException e) {
                logger.error("Error generating CSS.", (Throwable)e);
            }
        }
        return css;
    }
}

