/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.resource;

import com.ibm.ba.glass.resource.BaseCustomizationResource;
import com.ibm.ba.glass.resource.Resource;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Date;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFile
extends BaseCustomizationResource
implements StreamingOutput,
Resource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFile.class);
    protected File file;

    public ResourceFile(File file) {
        this.file = file;
    }

    public ResourceFile(String path) {
        this.setFileByPath(path);
    }

    protected void setFileByPath(String path) {
        this.file = new File(path);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public Date getLastModified() {
        return this.file.exists() ? new Date(this.file.lastModified()) : new Date();
    }

    @Override
    public String getResourceAsString() throws IOException {
        int len;
        byte[] buffer = new byte[2048];
        FileInputStream is = new FileInputStream(this.file);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((len = ((InputStream)is).read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        ((InputStream)is).close();
        return os.toString();
    }

    protected void writeStringToFile(String string) throws ESException {
        BufferedWriter writer = null;
        try {
            writer = this.createWriter(this.file);
            writer.write(string);
        }
        catch (IOException e) {
            throw new ESException("Failed to create: " + this.file.getName(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Exception:", (Throwable)e);
                }
            }
        }
    }

    protected BufferedWriter createWriter(File file) throws IOException {
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        return new BufferedWriter(fw);
    }

    public void write(OutputStream out) throws IOException {
        FileInputStream is = new FileInputStream(this.file);
        IOUtils.copy((InputStream)is, (OutputStream)out);
        is.close();
    }

    @Override
    public boolean delete() {
        if (this.file == null || !this.file.exists()) {
            return false;
        }
        return this.file.delete();
    }

    @Override
    public void update(String string) throws ESException {
        this.writeStringToFile(string);
    }

    @Override
    public String getName() {
        if (this.file == null) {
            return null;
        }
        return this.file.getName();
    }

    @Override
    public JsonObject getResourceAsJson() {
        try {
            JsonParser parser = new JsonParser();
            FileReader reader = new FileReader(this.file);
            JsonObject json = (JsonObject)parser.parse((Reader)reader);
            reader.close();
            return json;
        }
        catch (Exception e) {
            String msg = "Error gettting resource as json.";
            if (this.file != null) {
                msg = "Error gettting resource " + this.file.getPath() + " as json.";
            }
            LOGGER.error(msg, (Throwable)e);
            return null;
        }
    }
}

