/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.resource;

import com.ibm.ba.glass.defaults.DefaultTheme;
import com.ibm.ba.glass.resource.ThemeResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeCssResource
extends ThemeResource {
    @Inject
    private DefaultTheme defaultTheme;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeCssResource.class);

    public void initialize(String name) {
        this.initialize("themes", name, "css" + File.separator + "palette.css");
    }

    public void initialize(String customizationFolder, String name) {
        this.initialize(customizationFolder, name, "css" + File.separator + "palette.css");
    }

    @Override
    protected InputStream getInputStream() throws FileNotFoundException {
        InputStream inputStream;
        String themeId = this.getThemeName();
        if (this.builtInThemes.isBuiltIn(themeId)) {
            String palette = this.builtInThemes.getPalette(themeId);
            inputStream = new ByteArrayInputStream(palette.getBytes());
        } else {
            try {
                inputStream = this.getDefaultInputStream();
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Could not find palette for themeId: " + themeId + ". Using Default theme palette instead.");
                inputStream = new ByteArrayInputStream(this.defaultTheme.getPalette().getBytes());
            }
        }
        return inputStream;
    }

    protected InputStream getDefaultInputStream() throws FileNotFoundException {
        return super.getInputStream();
    }
}

