/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.resource;

import com.ibm.ba.glass.resource.ThemeResource;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeFavIconResource
extends ThemeResource {
    private String pathInZip;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeFavIconResource.class);

    public void initialize(String themeName, String pathInZip) {
        super.initialize("themes", themeName, pathInZip);
        this.pathInZip = pathInZip;
    }

    @Override
    public void initialize(String customizationFolder, String themeName, String pathInZip) {
        super.initialize(customizationFolder, themeName, pathInZip);
        this.pathInZip = pathInZip;
    }

    @Override
    protected InputStream getInputStream() throws FileNotFoundException {
        InputStream inputStream;
        if (this.isBuiltInTheme()) {
            String themeId = this.getThemeName();
            byte[] favicon = this.builtInThemes.getFavicon(themeId);
            if (favicon == null) {
                favicon = new byte[]{};
                LOGGER.warn("Could not find favicon for themeId: " + themeId);
            }
            inputStream = new ByteArrayInputStream(favicon);
        } else {
            inputStream = this.getDefaultInputStream();
        }
        return inputStream;
    }

    public String getPathInZip() {
        return this.pathInZip;
    }

    protected InputStream getDefaultInputStream() throws FileNotFoundException {
        try {
            return super.getInputStream();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find favicon for themeId: " + this.getThemeName());
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    protected boolean isBuiltInTheme() {
        String themeId = this.getThemeName();
        return this.pathInZip == null || this.builtInThemes.isBuiltIn(themeId);
    }

    @Override
    public String getMediaType() {
        if (this.isBuiltInTheme()) {
            return "image/png";
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("svg", "image/svg+xml");
        hm.put("png", "image/png");
        hm.put("jpg", "image/jpg");
        hm.put("jpeg", "image/jpeg");
        hm.put("gif", "image/gif");
        String[] tokens = this.pathInZip.split("\\.");
        String ext = tokens[tokens.length - 1];
        return (String)hm.get(ext.toLowerCase());
    }
}

