/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.resource;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ThemeSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeSchema.class);
    private static final String THEME_SCHEMA = "themeSchema.json";
    private String schema = null;

    @PostConstruct
    public void initialize() {
        this.schema = this.loadThemeSchema();
    }

    public String getSchema() {
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadThemeSchema() {
        String themeSchema = null;
        InputStream is = null;
        try {
            is = ThemeSchema.class.getClassLoader().getResourceAsStream(THEME_SCHEMA);
            themeSchema = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            LOGGER.error("Exception:", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error closing streams.", (Throwable)e);
                }
            }
        }
        return themeSchema;
    }
}

