/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.resource;

import com.ibm.ba.glass.defaults.DefaultTheme;
import com.ibm.ba.glass.exception.ResourceNotFoundException;
import com.ibm.ba.glass.resource.ThemeResource;
import com.ibm.ba.glass.utils.ESException;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import com.ibm.bi.json.JsonWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeSpecResource
extends ThemeResource {
    @Inject
    private DefaultTheme defaultTheme;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeSpecResource.class);

    public void initialize(String themeName) {
        this.initialize("themes", themeName, "spec.json");
    }

    public void initialize(String customizationFolder, String themeName) {
        this.initialize(customizationFolder, themeName, "spec.json");
    }

    @Override
    public JsonObject getResourceAsJson() throws ESException {
        Lock lock;
        JsonObject result;
        FileReader reader;
        block7: {
            reader = null;
            result = null;
            lock = this.getLock().readLock();
            lock.lock();
            try {
                String themeId = this.getThemeName();
                if (this.builtInThemes.isBuiltIn(themeId)) {
                    result = this.builtInThemes.getSpec(themeId);
                    break block7;
                }
                JsonParser parser = this.getJsonParser();
                try {
                    reader = this.getFileReader();
                    result = (JsonObject)parser.parse((Reader)reader);
                    reader.close();
                }
                catch (FileNotFoundException e) {
                    LOGGER.warn("Could not find spec for themeId: " + themeId + ". Using Default theme spec instead.");
                    result = this.defaultTheme.getSpec();
                }
            }
            catch (Exception e) {
                try {
                    throw new ESException("Failed to parse json file", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    lock.unlock();
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        lock.unlock();
        return result;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        try {
            JsonWriter writer = this.getJsonWriter();
            writer.write(out, (Object)this.getResourceAsJson());
        }
        catch (ESException ese) {
            if (ese.getCause() instanceof FileNotFoundException) {
                throw new ResourceNotFoundException(ese.getCause());
            }
            throw new IOException(ese);
        }
    }

    protected JsonWriter getJsonWriter() {
        return new JsonWriter(false);
    }

    @Override
    public String getMediaType() {
        return "application/json";
    }
}

