/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.resource;

import com.ibm.ba.glass.exception.InvalidInputException;
import com.ibm.ba.glass.resource.Specification;
import com.ibm.ba.glass.utils.GlassCommonMessageKeys;
import com.ibm.bi.json.JsonObject;

public class ThemeSpecification
implements Specification {
    private static final String SPEC_NAME = "name";
    private static final String SPEC_COLORS = "colors";
    private String name;
    private JsonObject spec;

    public ThemeSpecification(JsonObject specification, String name) throws InvalidInputException {
        this.spec = specification;
        if (name == null) {
            this.name = specification.getString(SPEC_NAME);
        } else if (name.equals(specification.getString(SPEC_NAME))) {
            this.name = name;
        } else {
            throw new InvalidInputException(GlassCommonMessageKeys.INVALID_CUSTOMIZATION_NAME, specification.getString(SPEC_NAME));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JsonObject getColors() {
        return (JsonObject)this.spec.get(SPEC_COLORS);
    }

    @Override
    public JsonObject getJsonSpec() {
        return this.spec;
    }
}

