/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.resource;

import com.ibm.ba.glass.resource.BaseCustomizationResource;
import com.ibm.ba.glass.resource.CustomizationResource;
import java.io.ByteArrayOutputStream;

public class ZippedFile
extends BaseCustomizationResource
implements Comparable<ZippedFile>,
CustomizationResource {
    private String name;
    private ByteArrayOutputStream os;

    public ZippedFile(String name, ByteArrayOutputStream stream) {
        this.name = name;
        this.os = stream;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ByteArrayOutputStream getData() {
        return this.os;
    }

    @Override
    public int compareTo(ZippedFile zippedFile) {
        return this.getName().compareTo(zippedFile.getName());
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ZippedFile) {
            return this.getName().equals(((ZippedFile)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getParentFolder() {
        int linuxSeperatorIndex;
        int winSeparatorIndex = this.name.lastIndexOf("\\");
        int lastIndex = winSeparatorIndex > (linuxSeperatorIndex = this.name.lastIndexOf("/")) ? winSeparatorIndex : (linuxSeperatorIndex == -1 ? 0 : linuxSeperatorIndex);
        return this.name.substring(0, lastIndex);
    }

    public String getRelativePath(String parent) {
        String path = null;
        if (this.isChildOf(parent)) {
            path = this.name.substring(parent.length());
            path = path.indexOf("/") == 0 || path.indexOf("\\") == 0 ? path.substring(1) : path;
        }
        return path;
    }

    public boolean isChildOf(String parent) {
        return parent.isEmpty() || parent.equals(this.name) || this.name.startsWith(parent + "/") || this.name.startsWith(parent + "\\");
    }
}

