/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.spi;

import com.ibm.ba.glass.api.BaseContextPart;
import com.ibm.ba.glass.api.ContextPart;
import com.ibm.ba.glass.api.RequestInfo;
import com.ibm.ba.glass.spi.PerspectiveContextPartProvider;
import com.ibm.ba.glass.utils.DeviceType;
import com.ibm.ba.glass.utils.UserAgentType;
import com.ibm.bi.json.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class HttpInfoContextProvider
implements PerspectiveContextPartProvider {
    @Override
    public ContextPart create(final RequestInfo requestInfo) {
        String userAgent = requestInfo.getRequest().getHeader("user-agent");
        DeviceType deviceType = this.getUserAgentType().getDeviceType(userAgent);
        final JsonObject value = new JsonObject();
        value.put("deviceType", (Object)deviceType.name());
        return new BaseContextPart(){

            @Override
            public JsonObject getValue() {
                return value;
            }

            @Override
            public String getName() {
                return "httpInfo";
            }

            @Override
            public String getEtagHash() {
                StringBuilder etagHashString = new StringBuilder();
                String jsonAsString = this.getValue().toString();
                if (jsonAsString != null) {
                    etagHashString.append(jsonAsString);
                }
                return String.valueOf(etagHashString.toString().hashCode());
            }

            @Override
            public Object getInnerData() {
                HashMap<String, Map> innerData = new HashMap<String, Map>();
                innerData.put("queryString", requestInfo.getRequest().getParameterMap());
                return innerData;
            }
        };
    }

    UserAgentType getUserAgentType() {
        return UserAgentType.getInstance();
    }
}

