/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.spi;

import com.ibm.ba.glass.api.BaseContextPart;
import com.ibm.ba.glass.api.ContextPart;
import com.ibm.ba.glass.api.RequestInfo;
import com.ibm.ba.glass.spi.PerspectiveContextPartProvider;
import com.ibm.bi.json.JsonObject;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.LocaleUtils;

public class LocaleContextPartProvider
implements PerspectiveContextPartProvider {
    private static final String LOCALE = "productLocale";
    private static final String CONTEXT_LOCALE = "locale";
    @Context
    private UriInfo uriInfo;

    @Override
    public ContextPart create(RequestInfo requestInfo) {
        final Locale locale = this.getLocale(requestInfo.getRequest());
        return new BaseContextPart(){

            @Override
            public String getName() {
                return LocaleContextPartProvider.CONTEXT_LOCALE;
            }

            @Override
            public Locale getLocale() {
                return locale;
            }

            @Override
            public JsonObject getValue() {
                return null;
            }

            @Override
            public String getEtagHash() {
                return null;
            }
        };
    }

    private Locale getLocale(HttpServletRequest req) {
        Locale locale = this.getQueryStringLocale();
        if (locale == null) {
            locale = this.getUserLocale(req);
        }
        return locale;
    }

    private Locale getUserLocale(HttpServletRequest req) {
        String lang = this.getLanguage(req);
        return Locale.forLanguageTag(lang);
    }

    private String getLanguage(HttpServletRequest req) {
        Locale lang = req.getLocale();
        return lang != null ? lang.getLanguage() : "en";
    }

    private Locale getQueryStringLocale() {
        String stringLocale = (String)this.uriInfo.getQueryParameters().getFirst((Object)LOCALE);
        if (stringLocale != null) {
            try {
                Locale locale = Locale.forLanguageTag(stringLocale);
                return LocaleUtils.isAvailableLocale((Locale)locale) ? locale : null;
            }
            catch (Exception error) {
                return null;
            }
        }
        return null;
    }
}

