/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.spi;

import com.ibm.ba.glass.api.PerspectiveContext;
import com.ibm.ba.glass.spi.PerspectiveFilter;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStringFilter
implements PerspectiveFilter {
    private static final String EQUALS_RULES = "EQUALS";
    private static final String EXACTLY_EQUALS_RULES = "EXACTLY_EQUALS";
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryStringFilter.class);
    private static final String FILTER_ID = "queryStringFilter";

    @Override
    public boolean doFilter(JsonObject plugin, PerspectiveContext context) {
        JsonObject env = plugin.getObject("environment");
        if (env != null) {
            try {
                JsonArray queryString = env.getArray("queryString");
                Map<String, String[]> requestParameters = this.getRequestParameterMap(context);
                Map<String, Map<String, Set<String>>> queryRules = this.parsePerspectiveQueryStringRules(queryString);
                if (this.checkEqualityRule(requestParameters, queryRules.get(EQUALS_RULES))) {
                    return false;
                }
                if (this.checkExactlyEqualRules(requestParameters, queryRules.get(EXACTLY_EQUALS_RULES))) {
                    return false;
                }
            }
            catch (ClassCastException e) {
                LOGGER.warn("Cast exception trying to cast query string as array: " + env.toString());
            }
        }
        return true;
    }

    @Override
    public String getId() {
        return FILTER_ID;
    }

    private Map<String, String[]> getRequestParameterMap(PerspectiveContext context) {
        Map innerData = (Map)context.getInnerData("httpInfo");
        Map paramMap = (Map)innerData.get("queryString");
        return paramMap;
    }

    private Map<String, Map<String, Set<String>>> parsePerspectiveQueryStringRules(JsonArray queryStrings) {
        HashMap<String, Map<String, Set<String>>> ret = new HashMap<String, Map<String, Set<String>>>();
        HashMap<String, Set<String>> equalsRules = null;
        HashMap<String, Set<String>> exactlyEqualsRules = null;
        if (queryStrings == null) {
            LOGGER.info("Query string Json array is null.");
        } else {
            for (Object obj : queryStrings) {
                String[] tokens;
                if (!(obj instanceof String)) {
                    LOGGER.error("Query string data type is not string.");
                    continue;
                }
                String queryStr = (String)obj;
                if (queryStr.contains("==")) {
                    if (exactlyEqualsRules == null) {
                        exactlyEqualsRules = new HashMap<String, Set<String>>();
                        ret.put(EXACTLY_EQUALS_RULES, exactlyEqualsRules);
                    }
                    tokens = queryStr.split("==");
                    this.addToMap(tokens, exactlyEqualsRules);
                    continue;
                }
                if (queryStr.contains("=")) {
                    if (equalsRules == null) {
                        equalsRules = new HashMap<String, Set<String>>();
                        ret.put(EQUALS_RULES, equalsRules);
                    }
                    tokens = queryStr.split("=");
                    this.addToMap(tokens, equalsRules);
                    continue;
                }
                LOGGER.error("Query string key or value is missing.");
            }
        }
        return ret;
    }

    private void addToMap(String[] tokens, Map<String, Set<String>> map) {
        if (tokens.length == 2) {
            if (map.containsKey(tokens[0])) {
                map.get(tokens[0]).add(tokens[1]);
            } else {
                HashSet<String> values = new HashSet<String>();
                values.add(tokens[1]);
                map.put(tokens[0], values);
            }
        }
    }

    private boolean checkExactlyEqualRules(Map<String, String[]> requestParameters, Map<String, Set<String>> rules) {
        if (rules == null || rules.isEmpty()) {
            return false;
        }
        if (requestParameters == null || requestParameters.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, Set<String>> rule : rules.entrySet()) {
            String requestValue;
            String parameter = rule.getKey();
            if (!requestParameters.containsKey(parameter)) {
                return true;
            }
            String[] requestValues = requestParameters.get(parameter);
            boolean matchFound = false;
            Set<String> perspectiveValues = rule.getValue();
            String[] stringArray = requestValues;
            int n = stringArray.length;
            for (int i = 0; i < n && !(matchFound = perspectiveValues.contains(requestValue = stringArray[i])); ++i) {
            }
            if (!matchFound) continue;
            return false;
        }
        return true;
    }

    private boolean checkEqualityRule(Map<String, String[]> requestParameters, Map<String, Set<String>> rules) {
        if (requestParameters == null || requestParameters.isEmpty() || rules == null || rules.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Set<String>> rule : rules.entrySet()) {
            String requestValue;
            String parameter = rule.getKey();
            if (!requestParameters.containsKey(parameter)) continue;
            String[] requestValues = requestParameters.get(parameter);
            boolean matchFound = false;
            Set<String> perspectiveValues = rule.getValue();
            String[] stringArray = requestValues;
            int n = stringArray.length;
            for (int i = 0; i < n && !(matchFound = perspectiveValues.contains(requestValue = stringArray[i])); ++i) {
            }
            if (matchFound) continue;
            return true;
        }
        return false;
    }
}

