/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.utils;

import com.ibm.bi.json.JsonObject;
import java.time.Instant;
import java.util.Date;
import javax.ws.rs.core.EntityTag;

public class CacheArtifact {
    private long version;
    private String id;
    private Date modificationTime;
    private String name;
    private EntityTag entityTag;
    private JsonObject specData;
    public static final String OBJ_NAME = "defaultName";
    public static final String OBJ_VERSION = "version";
    public static final String OBJ_MOD_TIME = "modificationTime";
    public static final String OBJ_ID = "id";
    private static final String SCHEMA_VERSION = "schemaVersion";

    public CacheArtifact(JsonObject anObj) {
        this.version = (Long)anObj.get(OBJ_VERSION);
        this.id = (String)anObj.get(OBJ_ID);
        String objModTimeString = (String)anObj.get(OBJ_MOD_TIME);
        Instant instant = Instant.parse(objModTimeString);
        this.modificationTime = new Date(Date.from(instant).getTime() / 1000L * 1000L);
        this.name = anObj.getString(OBJ_NAME);
        String etagComputation = this.name + this.version;
        this.entityTag = new EntityTag(Integer.toString(etagComputation.hashCode()));
        this.specData = null;
    }

    public CacheArtifact(JsonObject anObj, JsonObject spec) {
        this(anObj);
        this.specData = spec;
        if (spec != null) {
            String etagComputation = this.name + this.version + spec.getString(SCHEMA_VERSION);
            this.entityTag = new EntityTag(Integer.toString(etagComputation.hashCode()));
        }
    }

    @Deprecated
    public CacheArtifact(long version, String id, Date modificationTime) {
        this.id = id;
        this.version = version;
        this.modificationTime = modificationTime;
    }

    public long getVersion() {
        return this.version;
    }

    public String getId() {
        return this.id;
    }

    public Date getModificationTime() {
        return this.modificationTime;
    }

    public String getName() {
        return this.name;
    }

    public EntityTag getEntityTag() {
        return this.entityTag;
    }

    public JsonObject getSpecData() {
        return this.specData;
    }

    public static CacheArtifact createTemporaryCacheArtifact(String name) {
        JsonObject object = new JsonObject();
        object.put(OBJ_NAME, (Object)name);
        object.put(OBJ_MOD_TIME, (Object)new Date(0L).toInstant().toString());
        object.put(OBJ_VERSION, (Object)0);
        return new CacheArtifact(object);
    }
}

