/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.utils;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPropertyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomPropertyUtils.class);

    public static String readCustomProperty(String lookupValue, String defaultValue) {
        String name = CustomPropertyUtils.tryJNDI(lookupValue);
        if (name == null) {
            name = CustomPropertyUtils.trySystemProperty(lookupValue);
        }
        if (name == null) {
            name = defaultValue;
        }
        return name;
    }

    private static String tryJNDI(String jndiLookup) {
        try {
            InitialContext context = new InitialContext();
            String name = context.lookup(jndiLookup).toString();
            return name;
        }
        catch (NamingException ex) {
            LOGGER.info("JNDI value for {} not set.", (Object)jndiLookup);
            return null;
        }
    }

    private static String trySystemProperty(String systemPropLookup) {
        return System.getProperty(systemPropLookup);
    }
}

