/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.utils;

import com.ibm.ba.glass.resource.ResourceFile;
import com.ibm.ba.glass.utils.ESException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class DirectoryHandler {
    public File createDirectory(String path, boolean rewrite) throws ESException {
        File dir = this.getFile(path);
        if (dir.exists()) {
            if (!rewrite) {
                return dir;
            }
            this.deleteDirectory(dir);
        }
        dir.mkdirs();
        return dir;
    }

    public void deleteDirectory(File dir) throws ESException {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            throw new ESException("Error deleting directory: " + dir, e);
        }
    }

    public File getFile(String path) {
        return new File(path);
    }

    public List<ResourceFile> walkDirectory(String path) throws ESException {
        final ArrayList<ResourceFile> resources = new ArrayList<ResourceFile>();
        try {
            Path start = Paths.get(path, new String[0]);
            Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                    resources.add(new ResourceFile(filePath.toFile()));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            throw new ESException("Error walking a file tree: " + path, e);
        }
        return resources;
    }
}

