/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.utils;

import com.ibm.ba.glass.exception.JSONFormatException;
import com.ibm.ba.glass.utils.GlassCommonMessageKeys;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.json.JSONObject;

public class JsonObjectUtils {
    private JsonObjectUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject loadFromFile(File file) throws JSONFormatException {
        try (FileInputStream in = new FileInputStream(file);){
            JsonObject jsonObject = JsonObjectUtils.convertToJsonObject(new JSONObject((InputStream)in));
            return jsonObject;
        }
        catch (Exception e) {
            throw new JSONFormatException(GlassCommonMessageKeys.ERROR_PARSING_JSON, file.toString(), e);
        }
    }

    public static JsonObject convertToJsonObject(JSONObject json) {
        return (JsonObject)JsonObject.toJson((Object)json);
    }

    public static JSONObject convertToJSONObject(JsonObject json) {
        return json != null ? new JSONObject((Map)json) : null;
    }

    public static Set<String> convertToSet(JsonArray json) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < json.size(); ++i) {
            result.add(json.getString(i));
        }
        return result;
    }
}

