/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;

public class ResourceBundleControl
extends ResourceBundle.Control {
    private String encoding = "UTF-8";
    private boolean disableCache = false;

    public ResourceBundleControl() {
    }

    public ResourceBundleControl(boolean disableCache) {
        this.disableCache = disableCache;
    }

    public ResourceBundleControl(String encoding) {
        this.encoding = encoding;
    }

    public ResourceBundleControl(String encoding, boolean disableCache) {
        this.encoding = encoding;
        this.disableCache = disableCache;
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        return !this.disableCache ? super.getTimeToLive(baseName, locale) : -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        InputStream stream;
        PropertyResourceBundle bundle;
        block30: {
            String bundleName = this.toBundleName(baseName, locale);
            bundle = null;
            if ("java.class".equals(format)) {
                throw new UnsupportedOperationException();
            }
            if (!"java.properties".equals(format)) throw new IllegalArgumentException("unknown format: " + format);
            final String resourceName = this.toResourceName(bundleName, "properties");
            final ClassLoader classLoader = loader;
            stream = null;
            try {
                stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return classLoader.getResourceAsStream(resourceName);
                    }
                });
                if (stream == null) break block30;
            }
            catch (PrivilegedActionException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try (InputStreamReader isr = new InputStreamReader(stream, this.encoding);){
                            bundle = new PropertyResourceBundle(isr);
                        }
                    }
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            try (InputStreamReader isr = new InputStreamReader(stream, this.encoding);){
                bundle = new PropertyResourceBundle(isr);
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return bundle;
    }
}

